/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.action.RedoAction;
import net.sourceforge.squirrel_sql.client.session.action.UndoAction;
import net.sourceforge.squirrel_sql.client.session.action.UndoRedoActionContext;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IUndoHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SquirrelDefaultUndoManager;

public class UndoHandlerImpl
implements IUndoHandler {
    private SquirrelDefaultUndoManager _undoManager;
    private IUndoHandler _undoHandler;

    public UndoHandlerImpl(ISQLEntryPanel sqlEntryPanel) {
        if (!sqlEntryPanel.hasOwnUndoableManager()) {
            this._undoManager = new SquirrelDefaultUndoManager();
            sqlEntryPanel.setUndoManager(this._undoManager);
        } else {
            this._undoHandler = sqlEntryPanel.createUndoHandler();
        }
        SquirrelResources res = Main.getApplication().getResources();
        JTextArea comp = sqlEntryPanel.getTextComponent();
        comp.registerKeyboardAction(this.getUndoAction(), res.getKeyStroke(this.getUndoAction()), 1);
        comp.registerKeyboardAction(this.getRedoAction(), res.getKeyStroke(this.getRedoAction()), 1);
        sqlEntryPanel.addUndoRedoActionsToSQLEntryAreaMenu(this.getUndoAction(), this.getRedoAction());
    }

    @Override
    public UndoAction getUndoAction() {
        return (UndoAction)Main.getApplication().getActionCollection().get(UndoAction.class);
    }

    @Override
    public RedoAction getRedoAction() {
        return (RedoAction)Main.getApplication().getActionCollection().get(RedoAction.class);
    }

    public UndoRedoActionContext getUndoRedoActionContext() {
        if (null != this._undoHandler) {
            return new UndoRedoActionContext(this._undoHandler.getUndoAction(), this._undoHandler.getRedoAction());
        }
        return new UndoRedoActionContext(this._undoManager);
    }
}

