/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack;

import com.github.difflib.patch.InsertDelta;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.AddedLinesPopupPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.CursorHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GutterItem;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GutterItemUtil;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class AddedLinesGutterItem
implements GutterItem {
    private ChangeTrackPanel _changeTrackPanel;
    private final ISQLEntryPanel _sqlEntry;
    private InsertDelta<String> _delta;

    public AddedLinesGutterItem(ChangeTrackPanel changeTrackPanel, ISQLEntryPanel sqlEntry, InsertDelta<String> delta) {
        this._changeTrackPanel = changeTrackPanel;
        this._sqlEntry = sqlEntry;
        this._delta = delta;
    }

    @Override
    public void leftPaint(Graphics g) {
        int newLinesCount;
        int beginLine = this.getBeginLine();
        Rectangle rect = GutterItemUtil.getLeftGutterBoundsForLines(this._sqlEntry, beginLine, newLinesCount = this.getNewLinesCount());
        if (null == rect) {
            return;
        }
        Color buf = g.getColor();
        g.setColor(this.getColor());
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        g.setColor(buf);
    }

    private Color getColor() {
        return new Color(150, 180, 150);
    }

    @Override
    public void rightPaint(Graphics g) {
        Rectangle mark = GutterItemUtil.getRightGutterMarkBoundsForLines(this._changeTrackPanel, this._sqlEntry, this.getBeginLine(), this.getNewLinesCount());
        GutterItemUtil.paintRightGutterMark(g, mark, this.getColor());
    }

    @Override
    public void leftGutterMouseMoved(MouseEvent e, CursorHandler cursorHandler) {
        Rectangle rect = GutterItemUtil.getLeftGutterBoundsForLines(this._sqlEntry, this.getBeginLine(), this.getNewLinesCount());
        if (null == rect) {
            return;
        }
        cursorHandler.setClickable(rect.intersects(new Rectangle(e.getPoint(), new Dimension(1, 1))));
    }

    @Override
    public void rightMoveCursorWhenHit(MouseEvent e) {
        Rectangle mark = GutterItemUtil.getRightGutterMarkBoundsForLines(this._changeTrackPanel, this._sqlEntry, this.getBeginLine(), this.getNewLinesCount());
        if (null == mark) {
            return;
        }
        if (mark.intersects(new Rectangle(e.getPoint(), new Dimension(1, 1)))) {
            try {
                int lineStartPosition = this._sqlEntry.getTextComponent().getLineStartOffset(this.getBeginLine() - 1);
                GutterItemUtil.positionCaretAndScroll(lineStartPosition, this._sqlEntry);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void rightGutterMouseMoved(MouseEvent e, CursorHandler cursorHandler) {
        Rectangle mark = GutterItemUtil.getRightGutterMarkBoundsForLines(this._changeTrackPanel, this._sqlEntry, this.getBeginLine(), this.getNewLinesCount());
        if (null == mark) {
            return;
        }
        cursorHandler.setClickable(mark.intersects(new Rectangle(e.getPoint(), new Dimension(1, 1))));
    }

    @Override
    public void leftShowPopupIfHit(MouseEvent e, JPanel trackingGutterLeft) {
        Rectangle rect = GutterItemUtil.getLeftGutterBoundsForLines(this._sqlEntry, this.getBeginLine(), this.getNewLinesCount());
        if (null == rect) {
            return;
        }
        if (rect.intersects(new Rectangle(e.getPoint(), new Dimension(1, 1)))) {
            JPopupMenu popupMenu = new JPopupMenu();
            AddedLinesPopupPanel addedLinesPopupPanel = new AddedLinesPopupPanel();
            addedLinesPopupPanel.btnRevert.addActionListener(ae -> this.onRevert(popupMenu));
            popupMenu.add(addedLinesPopupPanel);
            popupMenu.show(trackingGutterLeft, 10, e.getY());
        }
    }

    private void onRevert(JPopupMenu popupMenu) {
        try {
            int beginPos = this._sqlEntry.getTextComponent().getLineStartOffset(this.getBeginLine() - 1);
            int endPos = this._sqlEntry.getTextComponent().getLineEndOffset(this.getBeginLine() - 1 + this.getNewLinesCount() - 1);
            if (endPos == this._sqlEntry.getText().length()) {
                --beginPos;
            }
            this._sqlEntry.setSelectionStart(beginPos);
            this._sqlEntry.setSelectionEnd(endPos);
            this._sqlEntry.replaceSelection("");
            popupMenu.setVisible(false);
        }
        catch (BadLocationException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private int getNewLinesCount() {
        return this._delta.getTarget().getLines().size();
    }

    private int getBeginLine() {
        return this._delta.getTarget().getPosition() + 1;
    }
}

