/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GutterPaintListener;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;

public class ChangeTrackPanel
extends JPanel {
    public static final int LEFT_GUTTER_WIDTH = 10;
    public static final int RIGHT_GUTTER_WIDTH = 11;
    public static final Color GUTTER_COLOR = new Color(255, 255, 204);
    JPanel trackingGutterRight;
    JPanel trackingGutterLeft;

    public ChangeTrackPanel(JScrollPane scrollPane, GutterPaintListener leftGutterPaintListener, GutterPaintListener rightGutterPaintListener) {
        this.setLayout(new BorderLayout());
        this.trackingGutterLeft = this.createTrackingGutter(10, leftGutterPaintListener);
        this.add((Component)this.trackingGutterLeft, "West");
        this.add((Component)scrollPane, "Center");
        this.trackingGutterRight = this.createTrackingGutter(11, rightGutterPaintListener);
        this.trackingGutterRight.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 1, Color.gray));
        this.add((Component)this.trackingGutterRight, "East");
    }

    private JPanel createTrackingGutter(int width, final GutterPaintListener gutterPaintListener) {
        JPanel trackingGutter = new JPanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                gutterPaintListener.paint(g);
            }
        };
        GUIUtils.setPreferredWidth(trackingGutter, width);
        trackingGutter.setBackground(GUTTER_COLOR);
        return trackingGutter;
    }

    public void requestGutterRepaint() {
        this.trackingGutterLeft.repaint();
        this.trackingGutterRight.repaint();
    }
}

