/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack;

import java.awt.Color;
import javax.swing.JColorChooser;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackPrefsPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.matchpatch.ChangeRenderer;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.matchpatch.ChangeRendererStyle;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class ChangeTrackPrefsPanelController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ChangeTrackPrefsPanelController.class);
    private ChangeTrackPrefsPanel _panel = new ChangeTrackPrefsPanel();

    public ChangeTrackPrefsPanel getPanel() {
        return this._panel;
    }

    public void loadData(SquirrelPreferences prefs) {
        this._panel.chkEnableChangeTracking.setSelected(prefs.isEnableChangeTracking());
        this._panel.chkEnableChangeTracking.addActionListener(e -> this.adjustUi());
        this._panel.chkGitCommitMsgManually.setSelected(prefs.isGitCommitMsgManually());
        this._panel.chkGitCommitMsgManually.addActionListener(e -> this.adjustUi());
        this._panel.txtGitCommitMsgDefault.setText(prefs.getGitCommitMsgDefault());
        this._panel.btnDeletedBold.setSelected(prefs.isDeletedBold());
        this._panel.btnDeletedBold.addActionListener(e -> this.adjustUi());
        this._panel.btnDeletedItalics.setSelected(prefs.isDeletedItalics());
        this._panel.btnDeletedItalics.addActionListener(e -> this.adjustUi());
        this._panel.setDeletedForeground(prefs.getDeletedForegroundRGB());
        this._panel.btnDeletedForeground.addActionListener(e -> this.onDeletedForeground());
        this._panel.setInsertBeginBackground(prefs.getInsertBeginBackgroundRGB());
        this._panel.btnInsertBeginBackground.addActionListener(e -> this.onInsertBeginBackground());
        this._panel.setInsertEndBackground(prefs.getInsertEndBackgroundRGB());
        this._panel.btnInsertEndBackground.addActionListener(e -> this.onInsertEndBackground());
        this.adjustUi();
    }

    private void onInsertEndBackground() {
        this._panel.setInsertEndBackground(this.chooseColorRgb(this._panel.getInsertEndBackground()));
        this.adjustUi();
    }

    private void onInsertBeginBackground() {
        this._panel.setInsertBeginBackground(this.chooseColorRgb(this._panel.getInsertBeginBackground()));
        this.adjustUi();
    }

    private void onDeletedForeground() {
        this._panel.setDeletedForeground(this.chooseColorRgb(this._panel.getDeletedForeground()));
        this.adjustUi();
    }

    private Integer chooseColorRgb(int curRgb) {
        Color color = JColorChooser.showDialog(this._panel, s_stringMgr.getString("ChangeTrackPrefsPanel.choose.color"), new Color(curRgb));
        if (null == color) {
            return null;
        }
        return color.getRGB();
    }

    private void adjustUi() {
        boolean ctEnabled = this._panel.chkEnableChangeTracking.isSelected();
        this._panel.chkGitCommitMsgManually.setEnabled(ctEnabled);
        this._panel.txtGitCommitMsgDefault.setEnabled(ctEnabled && false == this._panel.chkGitCommitMsgManually.isSelected());
        this._panel.btnDeletedBold.setEnabled(ctEnabled);
        this._panel.btnDeletedItalics.setEnabled(ctEnabled);
        this._panel.btnDeletedForeground.setEnabled(ctEnabled);
        this._panel.btnInsertBeginBackground.setEnabled(ctEnabled);
        this._panel.btnInsertEndBackground.setEnabled(ctEnabled);
        this._panel.txtExampleChangeTrackBase.setEnabled(ctEnabled);
        this._panel.txtExampleEditorText.setEnabled(ctEnabled);
        this._panel.txtExamplePopup.setEnabled(ctEnabled);
        ChangeRendererStyle changeRendererStyle = new ChangeRendererStyle();
        changeRendererStyle.setDeletedBold(this._panel.btnDeletedBold.isSelected());
        changeRendererStyle.setDeletedItalic(this._panel.btnDeletedItalics.isSelected());
        changeRendererStyle.setDeletedForgeGround(new Color(this._panel.getDeletedForeground()));
        changeRendererStyle.setAfterInsertColor(new Color(this._panel.getInsertEndBackground()));
        changeRendererStyle.setBeforeInsertColor(new Color(this._panel.getInsertBeginBackground()));
        this._panel.txtExamplePopup.setText(null);
        ChangeRenderer.renderChangeInTextPane(this._panel.txtExamplePopup, "SELECT Street, City, Country FROM Address\nWHERE SurName = 'Dow'", "SELECT Street, City FROM Address\nWHERE FirstName ='John' AND SurName = 'Dow'", changeRendererStyle);
    }

    public void applyChanges(SquirrelPreferences prefs) {
        prefs.setEnableChangeTracking(this._panel.chkEnableChangeTracking.isSelected());
        prefs.setGitCommitMsgManually(this._panel.chkGitCommitMsgManually.isSelected());
        if (!StringUtilities.isEmpty(this._panel.txtGitCommitMsgDefault.getText(), true)) {
            prefs.setGitCommitMsgDefault(this._panel.txtGitCommitMsgDefault.getText());
        }
        prefs.setDeletedBold(this._panel.btnDeletedBold.isSelected());
        prefs.setDeletedItalics(this._panel.btnDeletedItalics.isSelected());
        prefs.setDeletedForegroundRGB(this._panel.getDeletedForeground());
        prefs.setInsertBeginBackgroundRGB(this._panel.getInsertBeginBackground());
        prefs.setInsertEndBackgroundRGB(this._panel.getInsertEndBackground());
    }
}

