/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ActionUtil;
import net.sourceforge.squirrel_sql.client.session.action.ChangeTrackAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackActionUpdateListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackTypeEnum;
import net.sourceforge.squirrel_sql.fw.gui.buttonchooser.ButtonChooser;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ChangeTrackTypeChooser {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ChangeTrackTypeChooser.class);
    private final ChangeTrackActionUpdateListener _changeTrackActionUpdateListener;
    private ChangeTrackAction _action;
    private final ButtonChooser _buttonChooser = new ButtonChooser(true);
    private JButton _btnTrackManual;
    private JButton _btnTrackFile;
    private JButton _btnTrackGit;
    private boolean _dontReactToButtonSelect = false;

    public ChangeTrackTypeChooser(ChangeTrackAction action, ISession session) {
        this._action = action;
        this.initActionAndListeners();
        this._buttonChooser.setChooserEnabled(this._action.isEnabled());
        this._changeTrackActionUpdateListener = new ChangeTrackActionUpdateListener(){

            @Override
            public void activeSqlPanelApiChanged(ChangeTrackTypeEnum newSqlPanelAPIsChangeTrackType) {
                ChangeTrackTypeChooser.this.onSqlPanelApiChanged(newSqlPanelAPIsChangeTrackType);
            }

            @Override
            public void externallySetChangeTrackType(ChangeTrackTypeEnum newSqlPanelAPIsChangeTrackType) {
                ChangeTrackTypeChooser.this.onExternallySetChangeTrackType(newSqlPanelAPIsChangeTrackType);
            }
        };
        this._action.addChangeTrackActionUpdateListener(this._changeTrackActionUpdateListener);
        session.addSimpleSessionListener(() -> this._action.removeSQLPanelApiChangedListener(this._changeTrackActionUpdateListener));
    }

    private void onExternallySetChangeTrackType(ChangeTrackTypeEnum newSqlPanelAPIsChangeTrackType) {
        this.onSqlPanelApiChanged(newSqlPanelAPIsChangeTrackType);
    }

    private void onSqlPanelApiChanged(ChangeTrackTypeEnum newSqlPanelAPIsChangeTrackType) {
        if (null == newSqlPanelAPIsChangeTrackType) {
            this._buttonChooser.setChooserEnabled(false);
            return;
        }
        this._buttonChooser.setChooserEnabled(true);
        try {
            this._dontReactToButtonSelect = true;
            this.adjustChooserToType(newSqlPanelAPIsChangeTrackType);
        }
        finally {
            this._dontReactToButtonSelect = false;
        }
    }

    public JComponent getComponent() {
        return this._buttonChooser.getComponent();
    }

    private void initActionAndListeners() {
        SquirrelResources rsrc = Main.getApplication().getResources();
        ImageIcon iconTrackManual = rsrc.getIcon("changeTrackManual");
        ImageIcon iconTrackFile = rsrc.getIcon("changeTrackFile");
        ImageIcon iconTrackGit = rsrc.getIcon("changeTrackGit");
        String textTrackManual = s_stringMgr.getString("ChangeTrackTypeChooser.manual") + ActionUtil.getAcceleratorString(rsrc, this._action);
        String textTrackFile = s_stringMgr.getString("ChangeTrackTypeChooser.file") + ActionUtil.getAcceleratorString(rsrc, this._action);
        String textTrackGit = s_stringMgr.getString("ChangeTrackTypeChooser.git") + ActionUtil.getAcceleratorString(rsrc, this._action);
        String toolTipTrackManual = s_stringMgr.getString("ChangeTrackTypeChooser.manual.tooltip") + ActionUtil.getAcceleratorString(rsrc, this._action);
        String toolTipTrackFile = s_stringMgr.getString("ChangeTrackTypeChooser.file.tooltip") + ActionUtil.getAcceleratorString(rsrc, this._action);
        String toolTipTrackGit = s_stringMgr.getString("ChangeTrackTypeChooser.git.tooltip") + ActionUtil.getAcceleratorString(rsrc, this._action);
        this._btnTrackManual = new JButton(textTrackManual, iconTrackManual);
        this._btnTrackManual.setToolTipText(toolTipTrackManual);
        this.prolongTooltipDismissTime(this._btnTrackManual);
        this._btnTrackManual.addActionListener(e -> this._action.actionPerformed(e));
        this._buttonChooser.addButton(this._btnTrackManual);
        this._btnTrackFile = new JButton(textTrackFile, iconTrackFile);
        this._btnTrackFile.setToolTipText(toolTipTrackFile);
        this.prolongTooltipDismissTime(this._btnTrackFile);
        this._buttonChooser.addUnclickableButton(this._btnTrackFile);
        this._btnTrackGit = new JButton(textTrackGit, iconTrackGit);
        this._btnTrackGit.setToolTipText(toolTipTrackGit);
        this.prolongTooltipDismissTime(this._btnTrackGit);
        this._btnTrackGit.addActionListener(e -> this._action.actionPerformed(e));
        this._buttonChooser.addButton(this._btnTrackGit);
        this.adjustChooserToType(ChangeTrackTypeEnum.getPreference());
        this._buttonChooser.setButtonSelectedListener((button, formerSelectedButton) -> this.onButtonSelected(button, this._btnTrackManual, this._btnTrackFile, this._btnTrackGit));
    }

    private void prolongTooltipDismissTime(JButton btn) {
        final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
        btn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                ToolTipManager.sharedInstance().setDismissDelay(30000);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
            }
        });
    }

    private void adjustChooserToType(ChangeTrackTypeEnum type) {
        switch (type) {
            case MANUAL: {
                this._buttonChooser.setSelectedButton(this._btnTrackManual);
                break;
            }
            case FILE: {
                this._buttonChooser.setSelectedButton(this._btnTrackFile);
                break;
            }
            case GIT: {
                this._buttonChooser.setSelectedButton(this._btnTrackGit);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Type " + type);
            }
        }
    }

    private void onButtonSelected(AbstractButton button, JButton btnTrackManual, JButton btnTrackFile, JButton btnTrackGit) {
        ChangeTrackTypeEnum selectedType;
        if (this._dontReactToButtonSelect) {
            return;
        }
        if (button == btnTrackManual) {
            selectedType = ChangeTrackTypeEnum.MANUAL;
        } else if (button == btnTrackFile) {
            selectedType = ChangeTrackTypeEnum.FILE;
        } else if (button == btnTrackGit) {
            selectedType = ChangeTrackTypeEnum.GIT;
        } else {
            throw new IllegalStateException("How could we get here?");
        }
        selectedType.savePreference();
        this._action.changeTrackTypeChangedForCurrentSqlPanel(selectedType);
    }
}

