/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack;

import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.PreferencesAddressBook;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.filemanager.IFileEditorAPI;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackCloseDispatcher;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackTypeEnum;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GitHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GutterItem;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GutterItemsManager;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist.RevisionListController;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist.RevisionListControllerChannel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class ChangeTracker {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ChangeTracker.class);
    private final ISQLEntryPanel _sqlEntry;
    private ChangeTrackPanel _changeTrackPanel;
    private GutterItemsManager _gutterItemsManager;
    private boolean _enabled;
    private IFileEditorAPI _fileEditorAPI;
    private ChangeTrackCloseDispatcher _changeTrackCloseDispatcher = new ChangeTrackCloseDispatcher();

    public ChangeTracker(ISQLEntryPanel sqlEntry) {
        this._sqlEntry = sqlEntry;
        this._enabled = Main.getApplication().getSquirrelPreferences().isEnableChangeTracking();
        if (!this._enabled) {
            return;
        }
        JScrollPane scrollPane = sqlEntry.getTextAreaEmbeddedInScrollPane();
        this._changeTrackPanel = new ChangeTrackPanel(scrollPane, g -> this.onPaintLeftGutter(g), g -> this.onPaintRightGutter(g));
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void initChangeTracking(IFileEditorAPI fileEditorAPI) {
        if (!this._enabled) {
            return;
        }
        this._fileEditorAPI = fileEditorAPI;
        this._gutterItemsManager = new GutterItemsManager(this._sqlEntry, this._changeTrackPanel, fileEditorAPI);
        this._changeTrackPanel.trackingGutterLeft.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ChangeTracker.this.onLeftGutterMousePressed(e, true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ChangeTracker.this.onLeftGutterMousePressed(e, false);
            }
        });
        this._changeTrackPanel.trackingGutterLeft.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                ChangeTracker.this.onLeftGutterMouseMoved(e);
            }
        });
        this._changeTrackPanel.trackingGutterRight.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ChangeTracker.this.onRightGutterMousePressed(e);
            }
        });
        this._changeTrackPanel.trackingGutterRight.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                ChangeTracker.this.onRightGutterMouseMoved(e);
            }
        });
        this._sqlEntry.setTextAreaPaintListener(() -> this._changeTrackPanel.requestGutterRepaint());
    }

    public void reInitChangeTrackingOnFileMoved() {
        this.initChangeTracking(this._fileEditorAPI);
    }

    private void onLeftGutterMouseMoved(MouseEvent e) {
        this._gutterItemsManager.leftGutterMouseMoved(e, this._changeTrackPanel.trackingGutterLeft);
    }

    private void onLeftGutterMousePressed(MouseEvent me, boolean mousePressed) {
        if (me.isPopupTrigger()) {
            String changeTrackBase;
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem(s_stringMgr.getString("ChangeTracker.open.preferences"));
            menuItem.addActionListener(e -> this.onOpenChangeTrackPreferences());
            popupMenu.add(menuItem);
            if (ChangeTrackTypeEnum.getPreference() == ChangeTrackTypeEnum.GIT && null != this._fileEditorAPI.getFileHandler().getFile() && GitHandler.isInRepository(this._fileEditorAPI.getFileHandler().getFile())) {
                menuItem = new JMenuItem(s_stringMgr.getString("ChangeTracker.open.git.revisions", this._fileEditorAPI.getFileHandler().getFile().getName()));
                menuItem.addActionListener(e -> this.onShowGitRevisions(this._fileEditorAPI.getFileHandler().getFile()));
                popupMenu.add(menuItem);
            }
            if (!StringUtilities.isEmpty(changeTrackBase = this._gutterItemsManager.getGutterItemsProvider().getChangeTrackBase()) && this._gutterItemsManager.hasChanges()) {
                menuItem = new JMenuItem(s_stringMgr.getString("ChangeTracker.revert.all"));
                menuItem.addActionListener(e -> this._sqlEntry.setText(changeTrackBase));
                popupMenu.add(menuItem);
            }
            popupMenu.show(this._changeTrackPanel.trackingGutterLeft, me.getX(), me.getY());
        } else if (mousePressed) {
            this._gutterItemsManager.leftGutterMousePressed(me, this._changeTrackPanel.trackingGutterLeft);
        }
    }

    private void onShowGitRevisions(File file) {
        RevisionListControllerChannel revisionListControllerChannel = new RevisionListControllerChannel(){

            @Override
            public void replaceEditorContent(String newEditorContent) {
                ChangeTracker.this._sqlEntry.setText(newEditorContent);
            }

            @Override
            public void replaceChangeTrackBase(String newChangeTrackBase) {
                ChangeTracker.this._gutterItemsManager.getGutterItemsProvider().rebaseChangeTrackingBy(newChangeTrackBase);
            }

            @Override
            public String getEditorContent() {
                return ChangeTracker.this._sqlEntry.getText();
            }
        };
        new RevisionListController(this._sqlEntry.getTextComponent(), this._changeTrackCloseDispatcher, revisionListControllerChannel, file);
    }

    private void onOpenChangeTrackPreferences() {
        PreferencesAddressBook.CHANGE_TRACKING_PREFS.jumpTo();
    }

    private void onRightGutterMouseMoved(MouseEvent e) {
        this._gutterItemsManager.rightGutterMouseMoved(e, this._changeTrackPanel.trackingGutterRight);
    }

    private void onRightGutterMousePressed(MouseEvent e) {
        this._gutterItemsManager.rightGutterMousePressed(e);
    }

    private void onPaintRightGutter(Graphics g) {
        List<GutterItem> gutterItems = this._gutterItemsManager.getLeftGutterItems();
        for (GutterItem gutterItem : gutterItems) {
            gutterItem.rightPaint(g);
        }
    }

    private void onPaintLeftGutter(Graphics g) {
        List<GutterItem> gutterItems = this._gutterItemsManager.getLeftGutterItems();
        for (GutterItem gutterItem : gutterItems) {
            gutterItem.leftPaint(g);
        }
    }

    public JComponent embedInTracking() {
        if (this._enabled) {
            return this._changeTrackPanel;
        }
        return this._sqlEntry.getTextAreaEmbeddedInScrollPane();
    }

    public ChangeTrackTypeEnum getChangeTrackType() {
        return this._gutterItemsManager.getGutterItemsProvider().getChangeTrackType();
    }

    public void changeTrackTypeChanged(ChangeTrackTypeEnum selectedType) {
        this._gutterItemsManager.getGutterItemsProvider().changeTrackTypeChanged(selectedType);
    }

    public void rebaseChangeTrackingOnToolbarButtonOrMenuClicked() {
        if (!this._enabled) {
            return;
        }
        this._gutterItemsManager.getGutterItemsProvider().rebaseChangeTrackingOnToolbarButtonOrMenu();
    }

    public void close() {
        this._changeTrackCloseDispatcher.close();
    }
}

