/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack;

import com.github.difflib.patch.ChangeDelta;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.CursorHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GutterItem;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GutterItemUtil;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.RevertablePopupPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.matchpatch.ChangeRenderer;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.matchpatch.ChangeRendererStyle;
import net.sourceforge.squirrel_sql.fw.gui.ClipboardUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class ChangedLinesGutterItem
implements GutterItem {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ChangedLinesGutterItem.class);
    private ChangeTrackPanel _changeTrackPanel;
    private final ISQLEntryPanel _sqlEntry;
    private ChangeDelta<String> _delta;

    public ChangedLinesGutterItem(ChangeTrackPanel changeTrackPanel, ISQLEntryPanel sqlEntry, ChangeDelta<String> delta) {
        this._changeTrackPanel = changeTrackPanel;
        this._sqlEntry = sqlEntry;
        this._delta = delta;
    }

    @Override
    public void leftPaint(Graphics g) {
        int changedLinesCount;
        int beginLine = this.getBeginLine();
        Rectangle rect = GutterItemUtil.getLeftGutterBoundsForLines(this._sqlEntry, beginLine, changedLinesCount = this.getChangedLinesCount());
        if (null == rect) {
            return;
        }
        Color buf = g.getColor();
        g.setColor(this.getColor());
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        g.setColor(buf);
    }

    private Color getColor() {
        return new Color(200, 180, 230);
    }

    @Override
    public void rightPaint(Graphics g) {
        Rectangle mark = GutterItemUtil.getRightGutterMarkBoundsForLines(this._changeTrackPanel, this._sqlEntry, this.getBeginLine(), this.getChangedLinesCount());
        GutterItemUtil.paintRightGutterMark(g, mark, this.getColor());
    }

    @Override
    public void leftGutterMouseMoved(MouseEvent e, CursorHandler cursorHandler) {
        Rectangle rect = GutterItemUtil.getLeftGutterBoundsForLines(this._sqlEntry, this.getBeginLine(), this.getChangedLinesCount());
        if (null == rect) {
            return;
        }
        cursorHandler.setClickable(rect.intersects(new Rectangle(e.getPoint(), new Dimension(1, 1))));
    }

    @Override
    public void rightMoveCursorWhenHit(MouseEvent e) {
        Rectangle mark = GutterItemUtil.getRightGutterMarkBoundsForLines(this._changeTrackPanel, this._sqlEntry, this.getBeginLine(), this.getChangedLinesCount());
        if (null == mark) {
            return;
        }
        if (mark.intersects(new Rectangle(e.getPoint(), new Dimension(1, 1)))) {
            try {
                int lineStartPosition = this._sqlEntry.getTextComponent().getLineStartOffset(this.getBeginLine() - 1);
                GutterItemUtil.positionCaretAndScroll(lineStartPosition, this._sqlEntry);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void rightGutterMouseMoved(MouseEvent e, CursorHandler cursorHandler) {
        Rectangle mark = GutterItemUtil.getRightGutterMarkBoundsForLines(this._changeTrackPanel, this._sqlEntry, this.getBeginLine(), this.getChangedLinesCount());
        if (null == mark) {
            return;
        }
        cursorHandler.setClickable(mark.intersects(new Rectangle(e.getPoint(), new Dimension(1, 1))));
    }

    @Override
    public void leftShowPopupIfHit(MouseEvent me, JPanel trackingGutterLeft) {
        Rectangle rect = GutterItemUtil.getLeftGutterBoundsForLines(this._sqlEntry, this.getBeginLine(), this.getChangedLinesCount());
        if (null == rect) {
            return;
        }
        if (rect.intersects(new Rectangle(me.getPoint(), new Dimension(1, 1)))) {
            String sourceText = String.join((CharSequence)"\n", this._delta.getSource().getLines());
            String targetText = String.join((CharSequence)"\n", this._delta.getTarget().getLines());
            JPopupMenu popupMenu = new JPopupMenu();
            RevertablePopupPanel revertablePopupPanel = new RevertablePopupPanel(sourceText, this._sqlEntry.getTextComponent().getFont());
            revertablePopupPanel.btnCopy.addActionListener(ae -> ClipboardUtil.copyToClip(sourceText));
            revertablePopupPanel.btnRevert.addActionListener(ae -> this.onRevert(popupMenu));
            revertablePopupPanel.txtFormerText.setText("");
            ChangeRenderer.renderChangeInTextPane(revertablePopupPanel.txtFormerText, sourceText, targetText, ChangeRendererStyle.createFromPrefs());
            JScrollPane scrollPane = new JScrollPane(revertablePopupPanel);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            popupMenu.add(scrollPane);
            popupMenu.show(trackingGutterLeft, 10, me.getY());
        }
    }

    private void onRevert(JPopupMenu popupMenu) {
        try {
            int beginPos = this._sqlEntry.getTextComponent().getLineStartOffset(this.getBeginLine() - 1);
            int endPos = this._sqlEntry.getTextComponent().getLineEndOffset(this.getBeginLine() - 1 + this.getChangedLinesCount() - 1);
            this._sqlEntry.setSelectionStart(beginPos);
            this._sqlEntry.setSelectionEnd(endPos);
            Object revertText = endPos == this._sqlEntry.getText().length() && false == this.endsWithNewLine(this._sqlEntry.getText()) ? String.join((CharSequence)"\n", this._delta.getSource().getLines()) : String.join((CharSequence)"\n", this._delta.getSource().getLines()) + "\n";
            this._sqlEntry.replaceSelection((String)revertText);
            this._sqlEntry.setCaretPosition(beginPos);
            popupMenu.setVisible(false);
        }
        catch (BadLocationException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private boolean endsWithNewLine(String text) {
        if (0 == text.length()) {
            return false;
        }
        return '\n' == text.charAt(text.length() - 1);
    }

    private int getChangedLinesCount() {
        return this._delta.getTarget().getLines().size();
    }

    private int getBeginLine() {
        return this._delta.getTarget().getPosition() + 1;
    }
}

