/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack;

import com.github.difflib.patch.DeleteDelta;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.CursorHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GutterItem;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GutterItemUtil;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.RevertablePopupPanel;
import net.sourceforge.squirrel_sql.fw.gui.ClipboardUtil;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class DeletedLinesGutterItem
implements GutterItem {
    private ChangeTrackPanel _changeTrackPanel;
    private final ISQLEntryPanel _sqlEntry;
    private int _scriptLineCount;
    private DeleteDelta<String> _delta;

    public DeletedLinesGutterItem(ChangeTrackPanel changeTrackPanel, ISQLEntryPanel sqlEntry, int scriptLineCount, DeleteDelta<String> delta) {
        this._changeTrackPanel = changeTrackPanel;
        this._sqlEntry = sqlEntry;
        this._scriptLineCount = scriptLineCount;
        this._delta = delta;
    }

    @Override
    public void leftPaint(Graphics g) {
        int y = this.getYOfLine(this._sqlEntry, this.getDeletePosition());
        this.paintArrow(g, 0, y, 10, y);
    }

    private int getYOfLine(ISQLEntryPanel sqlEntry, int deletePosition) {
        Rectangle visibleRect = sqlEntry.getTextComponent().getVisibleRect();
        try {
            Rectangle2D rect = sqlEntry.getTextComponent().modelToView2D(sqlEntry.getTextComponent().getLineStartOffset(deletePosition));
            return this.correctYForEditorBegin((int)(rect.getY() - (double)visibleRect.y));
        }
        catch (BadLocationException e) {
            try {
                if (0 < sqlEntry.getTextComponent().getLineCount()) {
                    Rectangle2D rect = sqlEntry.getTextComponent().modelToView2D(sqlEntry.getTextComponent().getLineStartOffset(sqlEntry.getTextComponent().getLineCount() - 1));
                    return this.correctYForEditorBegin((int)(rect.getY() - (double)visibleRect.y + rect.getHeight()));
                }
                return this.correctYForEditorBegin(0);
            }
            catch (BadLocationException ex) {
                throw Utilities.wrapRuntime(ex);
            }
        }
    }

    private int correctYForEditorBegin(int y) {
        if (0 <= y && y < 2) {
            return 2;
        }
        return y;
    }

    @Override
    public void leftShowPopupIfHit(MouseEvent me, JPanel trackingGutterLeft) {
        if (this.intersects(me)) {
            String displayText = String.join((CharSequence)"\n", this._delta.getSource().getLines());
            JPopupMenu popupMenu = new JPopupMenu();
            RevertablePopupPanel revertablePopupPanel = new RevertablePopupPanel(displayText, this._sqlEntry.getTextComponent().getFont());
            revertablePopupPanel.btnCopy.addActionListener(ae -> ClipboardUtil.copyToClip(displayText));
            revertablePopupPanel.btnRevert.addActionListener(ae -> this.onRevert(popupMenu));
            popupMenu.add(revertablePopupPanel);
            popupMenu.show(trackingGutterLeft, 10, me.getY());
        }
    }

    private void onRevert(JPopupMenu popupMenu) {
        try {
            int insertPos = this._scriptLineCount <= this.getDeletePosition() ? this._sqlEntry.getTextComponent().getLineEndOffset(this._scriptLineCount - 1) : this._sqlEntry.getTextComponent().getLineStartOffset(this.getDeletePosition());
            this._sqlEntry.setCaretPosition(insertPos);
            String revertText = String.join((CharSequence)"\n", this._delta.getSource().getLines()) + "\n";
            this._sqlEntry.replaceSelection(revertText);
            popupMenu.setVisible(false);
        }
        catch (BadLocationException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private int getDeletePosition() {
        return this._delta.getTarget().getPosition();
    }

    private boolean intersects(MouseEvent e) {
        int y = this.getYOfLine(this._sqlEntry, this.getDeletePosition());
        Polygon triangle = this.getTriangle(0, y, 10, y);
        return triangle.getBounds().intersects(new Rectangle(e.getPoint(), new Dimension(1, 1)));
    }

    @Override
    public void rightPaint(Graphics g) {
        Rectangle mark = GutterItemUtil.getRightGutterMarkBoundsForLines(this._changeTrackPanel, this._sqlEntry, this.getDeletePosition(), 1);
        GutterItemUtil.paintRightGutterMark(g, mark, this.getColor());
    }

    @Override
    public void leftGutterMouseMoved(MouseEvent e, CursorHandler cursorHandler) {
        cursorHandler.setClickable(this.intersects(e));
    }

    @Override
    public void rightMoveCursorWhenHit(MouseEvent e) {
        Rectangle mark = GutterItemUtil.getRightGutterMarkBoundsForLines(this._changeTrackPanel, this._sqlEntry, this.getDeletePosition(), 1);
        if (null == mark) {
            return;
        }
        if (mark.intersects(new Rectangle(e.getPoint(), new Dimension(1, 1)))) {
            try {
                int lineStartPosition = this._sqlEntry.getTextComponent().getLineStartOffset(Math.max(this.getDeletePosition() - 1, 0));
                GutterItemUtil.positionCaretAndScroll(lineStartPosition, this._sqlEntry);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void rightGutterMouseMoved(MouseEvent e, CursorHandler cursorHandler) {
        Rectangle mark = GutterItemUtil.getRightGutterMarkBoundsForLines(this._changeTrackPanel, this._sqlEntry, this.getDeletePosition(), 1);
        if (null == mark) {
            return;
        }
        cursorHandler.setClickable(mark.intersects(new Rectangle(e.getPoint(), new Dimension(1, 1))));
    }

    private Color getColor() {
        return Color.black;
    }

    private void paintArrow(Graphics g, int x1, int y1, int x2, int y2) {
        Color buf = g.getColor();
        g.setColor(this.getColor());
        Polygon pg = this.getTriangle(x1, y1, x2, y2);
        g.fillPolygon(pg);
        g.setColor(buf);
    }

    private Polygon getTriangle(int x1, int y1, int x2, int y2) {
        double sAng = 0.5;
        Point c = new Point(x2, y2);
        Point a = new Point((int)((double)x1 + sAng * (double)(y2 - y1)), (int)((double)y1 - sAng * (double)(x2 - x1)));
        Point b = new Point((int)((double)x1 - sAng * (double)(y2 - y1)), (int)((double)y1 + sAng * (double)(x2 - x1)));
        double sLen = 10.0 / Math.sqrt((a.x - c.x) * (a.x - c.x) + (a.y - c.y) * (a.y - c.y));
        Point arrPa = new Point((int)((double)c.x + sLen * (double)(a.x - c.x)), (int)((double)c.y + sLen * (double)(a.y - c.y)));
        Point arrPb = new Point((int)((double)c.x + sLen * (double)(b.x - c.x)), (int)((double)c.y + sLen * (double)(b.y - c.y)));
        Polygon pg = new Polygon();
        pg.addPoint(arrPa.x, arrPa.y);
        pg.addPoint(arrPb.x, arrPb.y);
        pg.addPoint(c.x, c.y);
        return pg;
    }
}

