/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack;

import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GitCommitMessageDialog;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GitCommitMessageJsonBean;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.JsonMarshalUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import org.eclipse.jgit.lib.Repository;

public class GitCommitMessageController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GitCommitMessageController.class);
    private final GitCommitMessageDialog _dlg;
    private boolean _ok;
    private GitCommitMessageJsonBean _gitCommitMessageJsonBean = new GitCommitMessageJsonBean();

    public GitCommitMessageController(Frame parentFrame, String fileName, String filePathRelativeToRepoRoot, Repository repository) {
        this._dlg = new GitCommitMessageDialog(parentFrame, fileName, this.buildDescription(filePathRelativeToRepoRoot, repository));
        this._dlg.btnOk.addActionListener(e -> this.onOk());
        this._dlg.btnCancel.addActionListener(e -> this.onCancel());
        this._dlg.btnMessageHistory.addActionListener(e -> this.onShowMessageHistory());
        File jsonBeanFile = new ApplicationFiles().getGitCommitMessageJsonBeanFile();
        if (jsonBeanFile.exists()) {
            this._gitCommitMessageJsonBean = JsonMarshalUtil.readObjectFromFileSave(jsonBeanFile, GitCommitMessageJsonBean.class, new GitCommitMessageJsonBean());
        }
        this.setMessage(this._gitCommitMessageJsonBean.getLastEditorContent());
        this._dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GitCommitMessageController.this.saveState();
            }
        });
    }

    private void onShowMessageHistory() {
        JPopupMenu popupMenu = new JPopupMenu();
        final boolean[] messageClickedRef = new boolean[1];
        final String currentMessage = this._dlg.txtMessage.getText();
        for (String previousCommitMessage : this._gitCommitMessageJsonBean.getPreviousCommitMessages()) {
            JMenuItem menuItem = new JMenuItem(this.createMenuItemText(previousCommitMessage));
            menuItem.addChangeListener(e -> this.setMessage(previousCommitMessage));
            menuItem.addActionListener(e -> {
                messageClickedRef[0] = true;
            });
            popupMenu.add(menuItem);
        }
        popupMenu.show(this._dlg.btnMessageHistory, 0, this._dlg.btnMessageHistory.getHeight());
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                GitCommitMessageController.this.onPopupClosed(currentMessage, messageClickedRef);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    private void onPopupClosed(String formerMessage, boolean[] messageClickedRef) {
        if (!messageClickedRef[0]) {
            this.setMessage(formerMessage);
        }
    }

    private void onPreviousMessageClicked(String previousCommitMessage, boolean[] messageClickedRef) {
        this.setMessage(previousCommitMessage);
        messageClickedRef[0] = true;
    }

    private void setMessage(String previousCommitMessage) {
        this._dlg.txtMessage.setText(previousCommitMessage);
        SwingUtilities.invokeLater(() -> this._dlg.txtMessage.scrollRectToVisible(new Rectangle(0, 0, 1, 1)));
    }

    private String createMenuItemText(String previousCommitMessage) {
        Object ret = previousCommitMessage.split("\n")[0];
        if (((String)ret).length() > 50) {
            ret = ((String)ret).substring(0, 45) + "...";
        }
        return ret;
    }

    private void onCancel() {
        this.close();
    }

    private void onOk() {
        if (StringUtilities.isEmpty(this._dlg.txtMessage.getText(), true)) {
            String title = s_stringMgr.getString("GitCommitMessageController.empty.title");
            String msg = s_stringMgr.getString("GitCommitMessageController.empty.message");
            JOptionPane.showMessageDialog(this._dlg, msg, title, 0);
            return;
        }
        List<String> msgs = this._gitCommitMessageJsonBean.getPreviousCommitMessages();
        msgs.remove(this._dlg.txtMessage.getText());
        msgs.add(0, this._dlg.txtMessage.getText());
        while (10 < msgs.size()) {
            msgs.remove(msgs.size() - 1);
        }
        this._ok = true;
        this.close();
    }

    private void close() {
        this.saveState();
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private void saveState() {
        if (!StringUtilities.isEmpty(this._dlg.txtMessage.getText(), true)) {
            this._gitCommitMessageJsonBean.setLastEditorContent(this._dlg.txtMessage.getText());
        }
        JsonMarshalUtil.writeObjectToFile(new ApplicationFiles().getGitCommitMessageJsonBeanFile(), this._gitCommitMessageJsonBean);
    }

    private String buildDescription(String filePathRelativeToRepoRoot, Repository repository) {
        try {
            return s_stringMgr.getString("GitCommitMessageController.description", filePathRelativeToRepoRoot, repository.getBranch(), repository.getWorkTree().getPath());
        }
        catch (IOException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    public String getMessage() {
        GUIUtils.enableCloseByEscape(this._dlg);
        GUIUtils.initLocation(this._dlg, 400, 400);
        SwingUtilities.invokeLater(() -> this._dlg.txtMessage.requestFocus());
        this._dlg.setVisible(true);
        if (this._ok) {
            return this._dlg.txtMessage.getText();
        }
        return null;
    }
}

