/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class GitCommitMessageDialog
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GitCommitMessageDialog.class);
    JTextArea txtMessage;
    JButton btnMessageHistory;
    JButton btnOk;
    JButton btnCancel;

    public GitCommitMessageDialog(Frame parentFrame, String fileName, String description) {
        super(parentFrame, s_stringMgr.getString("GitCommitMessageDialog.title", fileName), true);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        this.getContentPane().add((Component)this.createDescriptionPanel(description), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0);
        this.txtMessage = new JTextArea();
        this.getContentPane().add((Component)new JScrollPane(this.txtMessage), gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.createOkCancelPanel(), gbc);
    }

    private JPanel createOkCancelPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0);
        this.btnOk = new JButton(s_stringMgr.getString("GitCommitMessageDialog.ok"));
        this.getRootPane().setDefaultButton(this.btnOk);
        ret.add((Component)this.btnOk, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.btnCancel = new JButton(s_stringMgr.getString("GitCommitMessageDialog.cancel"));
        ret.add((Component)this.btnCancel, gbc);
        return ret;
    }

    private JPanel createDescriptionPanel(String description) {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        ret.add((Component)new MultipleLineLabel(description), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(5, 0, 0, 0), 0, 0);
        this.btnMessageHistory = new JButton(Main.getApplication().getResources().getIcon("SQLHistory"));
        this.btnMessageHistory.setToolTipText(s_stringMgr.getString("GitCommitMessageDialog.message.history.tooltip"));
        GUIUtils.styleAsToolbarButton(this.btnMessageHistory);
        ret.add((Component)this.btnMessageHistory, gbc);
        return ret;
    }
}

