/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionUtil;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileManagementUtil;
import net.sourceforge.squirrel_sql.client.session.filemanager.IFileEditorAPI;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GitCommitMessageController;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.SelectGitRepoRootDirController;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist.RevisionWrapper;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RenameCallback;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GitHandler {
    public static final String GIT_MSG_FILE_NAME_PLACEHOLDER = "@file";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GitHandler.class);
    private static final ILogger s_log = LoggerController.createLogger(GitHandler.class);

    public static String getChangeTrackBaseFromGit(IFileEditorAPI fileEditorAPI, boolean commitToGit) {
        if (commitToGit) {
            return GitHandler.commit(fileEditorAPI);
        }
        return GitHandler.getCurrentRepoVersion(fileEditorAPI.getFileHandler().getFile());
    }

    private static String getCurrentRepoVersion(File file) {
        return GitHandler.getVersionOfFile(file, null);
    }

    public static String getVersionOfFile(File file, ObjectId revCommitId) {
        return GitHandler.getVersionOfFile(file, revCommitId, Set.of());
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static String getVersionOfFile(File file, ObjectId revCommitId, Set<String> previousNamesOfFileRelativeToRepositoryRoot) {
        if (null == file) {
            return null;
        }
        try (Repository repository = GitHandler.findRepository(file);){
            String string;
            TreeWalk treeWalk;
            RevWalk revWalk;
            block29: {
                ArrayList<PathFilter> pathFilters;
                if (null == repository) {
                    String string2 = null;
                    return string2;
                }
                String filePathRelativeToRepoRoot = GitHandler.getPathRelativeToRepo(repository, file);
                if (null == revCommitId) {
                    revCommitId = repository.resolve("HEAD");
                }
                if (null == revCommitId) {
                    String string3 = null;
                    return string3;
                }
                s_log.info("GIT: Reading HEAD revision of " + file.getPath());
                revWalk = new RevWalk(repository);
                RevCommit commit = revWalk.parseCommit((AnyObjectId)revCommitId);
                RevTree tree = commit.getTree();
                treeWalk = new TreeWalk(repository);
                treeWalk.addTree((AnyObjectId)tree);
                treeWalk.setRecursive(true);
                if (previousNamesOfFileRelativeToRepositoryRoot.isEmpty()) {
                    treeWalk.setFilter((TreeFilter)PathFilter.create((String)filePathRelativeToRepoRoot));
                } else {
                    pathFilters = new ArrayList<PathFilter>();
                    pathFilters.add(PathFilter.create((String)filePathRelativeToRepoRoot));
                    previousNamesOfFileRelativeToRepositoryRoot.forEach(f -> pathFilters.add(PathFilter.create((String)f)));
                    treeWalk.setFilter(OrTreeFilter.create((TreeFilter[])((TreeFilter[])pathFilters.toArray(new PathFilter[0]))));
                }
                if (treeWalk.next()) break block29;
                revWalk.dispose();
                pathFilters = null;
                treeWalk.close();
                revWalk.close();
                return pathFilters;
            }
            try {
                String ret;
                block30: {
                    ObjectId objectId = treeWalk.getObjectId(0);
                    ObjectLoader loader = repository.open((AnyObjectId)objectId);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    loader.copyTo((OutputStream)baos);
                    ret = StringUtilities.removeCarriageReturn(new String(baos.toByteArray()));
                    break block30;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    finally {
                        treeWalk.close();
                    }
                }
                revWalk.dispose();
                string = ret;
            }
            catch (Throwable throwable) {
                try {
                    revWalk.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            revWalk.close();
            return string;
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    public static String getPathRelativeToRepo(File file) {
        try (Repository repository = GitHandler.findRepository(file);){
            if (null == repository) {
                throw new IllegalStateException("Couldn't find repository for file " + file.getAbsolutePath());
            }
            String string = GitHandler.getPathRelativeToRepo(repository, file);
            return string;
        }
    }

    public static String getFilesRepositoryWorkTreePath(File file) {
        try (Repository repository = GitHandler.findRepository(file);){
            if (null == repository) {
                throw new IllegalStateException("Couldn't find repository for file " + file.getAbsolutePath());
            }
            String string = GitHandler.getRepositoryWorkTreePath(repository);
            return string;
        }
    }

    private static String commit(IFileEditorAPI fileEditorAPI) {
        Repository repository = null;
        Git git = null;
        try {
            if (!fileEditorAPI.getFileHandler().fileSave()) {
                String string = null;
                return string;
            }
            File file = fileEditorAPI.getFileHandler().getFile();
            repository = GitHandler.findRepository(file);
            if (null == repository) {
                File gitInitDir;
                if (SavedSessionUtil.isInSavedSessionsDir(file)) {
                    gitInitDir = null;
                    int option = JOptionPane.showConfirmDialog(Main.getApplication().getMainFrame(), s_stringMgr.getString("GitHandler.git.control.internal.saved.session.files.msg"), s_stringMgr.getString("GitHandler.git.control.internal.saved.session.files.title"), 1);
                    if (0 == option) {
                        gitInitDir = SavedSessionUtil.getSavedSessionsDir();
                    }
                } else {
                    gitInitDir = new SelectGitRepoRootDirController().getDir(file);
                }
                if (null == gitInitDir) {
                    String option = null;
                    return option;
                }
                git = Git.init().setDirectory(gitInitDir).call();
                repository = git.getRepository();
            } else {
                git = Git.open((File)repository.getDirectory());
                repository = git.getRepository();
            }
            String filePathRelativeToRepoRoot = GitHandler.getPathRelativeToRepo(repository, file);
            git.add().addFilepattern(filePathRelativeToRepoRoot).call();
            if (GitHandler.isModifiedOrAdded(filePathRelativeToRepoRoot, git)) {
                String msg;
                if (Main.getApplication().getSquirrelPreferences().isGitCommitMsgManually()) {
                    msg = new GitCommitMessageController(fileEditorAPI.getOwningFrame(), file.getName(), filePathRelativeToRepoRoot, repository).getMessage();
                    if (null == msg) {
                        String e = GitHandler.getCurrentRepoVersion(file);
                        return e;
                    }
                } else {
                    msg = Main.getApplication().getSquirrelPreferences().getGitCommitMsgDefault().replaceAll(GIT_MSG_FILE_NAME_PLACEHOLDER, filePathRelativeToRepoRoot);
                }
                RevCommit revCommit = git.commit().setOnly(filePathRelativeToRepoRoot).setMessage(msg).call();
                GitHandler.logCommit(repository, filePathRelativeToRepoRoot, revCommit);
            } else {
                Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("GitHandler.unmodified", file.getPath()));
            }
            String string = FileManagementUtil.readFileAsString(file);
            return string;
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
        finally {
            if (null != repository) {
                try {
                    repository.close();
                }
                catch (Exception e) {
                    s_log.warn("Error closing org.eclipse.jgit.lib.Repository", e);
                }
            }
            if (null != git) {
                try {
                    git.close();
                }
                catch (Exception e) {
                    s_log.warn("Error closing org.eclipse.jgit.api.Git", e);
                }
            }
        }
    }

    private static boolean isModifiedOrAdded(String filePathRelativeToRepoRoot, Git git) {
        try {
            Status status = git.status().addPath(filePathRelativeToRepoRoot).call();
            return 0 < status.getChanged().size() + status.getAdded().size();
        }
        catch (GitAPIException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private static void logCommit(Repository repository, String filePathRelativeToRepoRoot, RevCommit revCommit) {
        try {
            String msg = s_stringMgr.getString("GitHandler.commitMsg", filePathRelativeToRepoRoot, repository.getBranch(), GitHandler.getRepositoryWorkTreePath(repository), revCommit.getCommitterIdent().getName());
            Main.getApplication().getMessageHandler().showMessage(msg);
            String log = s_stringMgr.getString("GitHandler.commitLog", filePathRelativeToRepoRoot, repository.getBranch(), GitHandler.getRepositoryWorkTreePath(repository), revCommit.getCommitterIdent().getName(), revCommit.getId());
            s_log.info(log);
        }
        catch (IOException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private static String getRepositoryWorkTreePath(Repository repository) {
        return repository.getWorkTree().getPath();
    }

    private static Repository findRepository(File file) {
        try {
            FileRepositoryBuilder builder = (FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(file);
            if (null == builder.getGitDir()) {
                return null;
            }
            return builder.build();
        }
        catch (IOException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private static String getPathRelativeToRepo(Repository repository, File file) {
        return repository.getWorkTree().toURI().relativize(file.toURI()).getPath();
    }

    public static boolean isInRepository(File file) {
        try {
            Repository repository = GitHandler.findRepository(file);
            if (null == repository) {
                return false;
            }
            Git git = Git.open((File)repository.getDirectory());
            String filePathRelativeToRepoRoot = GitHandler.getPathRelativeToRepo(repository, file);
            Status status = git.status().addPath(filePathRelativeToRepoRoot).call();
            return null != status && 0 == status.getUntracked().size();
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<RevisionWrapper> getRevisions(File file) {
        ArrayList<RevisionWrapper> ret = new ArrayList<RevisionWrapper>();
        try (Repository repository = GitHandler.findRepository(file);){
            ArrayList<RevisionWrapper> arrayList;
            block15: {
                Git git = Git.open((File)repository.getDirectory());
                try {
                    StoredConfig config = repository.getConfig();
                    config.setBoolean("diff", null, "renames", true);
                    RevWalk rw = new RevWalk(repository);
                    DiffConfig dc = (DiffConfig)config.get(DiffConfig.KEY);
                    FollowFilter followFilter = FollowFilter.create((String)GitHandler.getPathRelativeToRepo(repository, file), (DiffConfig)dc);
                    final HashSet<String> previousNamesOfFileRelativeToRepositoryRoot = new HashSet<String>();
                    followFilter.setRenameCallback(new RenameCallback(){

                        public void renamed(DiffEntry entry) {
                            previousNamesOfFileRelativeToRepositoryRoot.add(entry.getOldPath());
                        }
                    });
                    rw.setTreeFilter((TreeFilter)followFilter);
                    rw.markStart(rw.parseCommit((AnyObjectId)repository.resolve("HEAD")));
                    ObjectId headCommitId = repository.resolve("HEAD");
                    for (RevCommit revCommit : rw) {
                        ret.add(new RevisionWrapper(revCommit, git, headCommitId, previousNamesOfFileRelativeToRepositoryRoot));
                    }
                    arrayList = ret;
                    if (git == null) break block15;
                }
                catch (Throwable throwable) {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                git.close();
            }
            return arrayList;
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    public static void commitDelete(File toDelete) {
        if (!GitHandler.isInRepository(toDelete)) {
            return;
        }
        try (Repository repository = GitHandler.findRepository(toDelete);
             Git git = Git.open((File)repository.getDirectory());){
            String pathRelativeToRepo = GitHandler.getPathRelativeToRepo(repository, toDelete);
            git.rm().addFilepattern(pathRelativeToRepo).call();
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean moveAndDeleteOld(File newFile, File previousFile) {
        if (!GitHandler.isInRepository(previousFile)) {
            GitHandler.deleteFilePhysically(previousFile);
            return false;
        }
        try (Repository newRepo = GitHandler.findRepository(newFile);){
            boolean bl;
            block26: {
                Repository oldRepo;
                block23: {
                    boolean bl2;
                    block25: {
                        oldRepo = GitHandler.findRepository(previousFile);
                        try {
                            if (null == newRepo || null == oldRepo || !GitHandler.getRepositoryWorkTreePath(newRepo).equals(GitHandler.getRepositoryWorkTreePath(oldRepo))) break block23;
                            try (Git git = Git.open((File)newRepo.getDirectory());){
                                String newFileRelativeToRepo = GitHandler.getPathRelativeToRepo(newRepo, newFile);
                                String previousFileRelativeToRepo = GitHandler.getPathRelativeToRepo(newRepo, previousFile);
                                git.add().addFilepattern(newFileRelativeToRepo).call();
                                git.rm().addFilepattern(previousFileRelativeToRepo).call();
                                git.status().addPath(newFileRelativeToRepo).addPath(previousFileRelativeToRepo).call();
                                RevCommit revCommit = git.commit().setOnly(newFileRelativeToRepo).setOnly(previousFileRelativeToRepo).setMessage(s_stringMgr.getString("GitHandler.move.committed", previousFile.getAbsolutePath(), newFile.getAbsolutePath())).call();
                                GitHandler.logMove(newRepo, previousFileRelativeToRepo, newFileRelativeToRepo, revCommit);
                            }
                            bl2 = true;
                            if (oldRepo == null) break block25;
                        }
                        catch (Throwable throwable) {
                            if (oldRepo != null) {
                                try {
                                    oldRepo.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        oldRepo.close();
                    }
                    return bl2;
                }
                GitHandler.deleteFilePhysically(previousFile);
                bl = false;
                if (oldRepo == null) break block26;
                oldRepo.close();
            }
            return bl;
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private static void deleteFilePhysically(File previousFile) {
        try {
            Files.deleteIfExists(Path.of(previousFile.toURI()));
        }
        catch (IOException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private static void logMove(Repository repository, String previousFileRelativeToRepo, String newFileRelativeToRepo, RevCommit revCommit) {
        try {
            String msg = s_stringMgr.getString("GitHandler.move.commitMsg", previousFileRelativeToRepo, newFileRelativeToRepo, repository.getBranch(), GitHandler.getRepositoryWorkTreePath(repository), revCommit.getCommitterIdent().getName());
            Main.getApplication().getMessageHandler().showMessage(msg);
            String log = s_stringMgr.getString("GitHandler.move.commitLog", previousFileRelativeToRepo, newFileRelativeToRepo, repository.getBranch(), GitHandler.getRepositoryWorkTreePath(repository), revCommit.getCommitterIdent().getName(), revCommit.getId());
            s_log.info(log);
        }
        catch (IOException e) {
            throw Utilities.wrapRuntime(e);
        }
    }
}

