/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.ChangeDelta;
import com.github.difflib.patch.DeleteDelta;
import com.github.difflib.patch.InsertDelta;
import com.github.difflib.patch.Patch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.AddedLinesGutterItem;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangedLinesGutterItem;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.DeletedLinesGutterItem;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GutterItem;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class GutterItemsCreator {
    public static List<GutterItem> createGutterItems(ISQLEntryPanel sqlEntry, ChangeTrackPanel changeTrackPanel, String changeTrackBase) {
        try {
            if (null == changeTrackBase) {
                return Collections.EMPTY_LIST;
            }
            List<String> changeTrackBaseLines = Arrays.asList(changeTrackBase.split("\n", -1));
            List<String> currentLines = Arrays.asList(sqlEntry.getText().split("\n", -1));
            Patch diff = DiffUtils.diff(changeTrackBaseLines, currentLines);
            ArrayList<GutterItem> gutterItems = new ArrayList<GutterItem>();
            for (AbstractDelta delta : diff.getDeltas()) {
                switch (delta.getType()) {
                    case INSERT: {
                        gutterItems.add(GutterItemsCreator.createAddedLinesGutterItem(sqlEntry, changeTrackPanel, (InsertDelta<String>)((InsertDelta)delta)));
                        break;
                    }
                    case CHANGE: {
                        gutterItems.add(GutterItemsCreator.createChangedLinesGutterItem(sqlEntry, changeTrackPanel, (ChangeDelta<String>)((ChangeDelta)delta)));
                        break;
                    }
                    case DELETE: {
                        gutterItems.add(GutterItemsCreator.createDeletedLinesGutterItem(sqlEntry, changeTrackPanel, (DeleteDelta<String>)((DeleteDelta)delta), currentLines.size()));
                    }
                }
            }
            return gutterItems;
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private static GutterItem createDeletedLinesGutterItem(ISQLEntryPanel sqlEntry, ChangeTrackPanel changeTrackPanel, DeleteDelta<String> delta, int currentLineCount) {
        return new DeletedLinesGutterItem(changeTrackPanel, sqlEntry, currentLineCount, delta);
    }

    private static GutterItem createChangedLinesGutterItem(ISQLEntryPanel sqlEntry, ChangeTrackPanel changeTrackPanel, ChangeDelta<String> delta) {
        return new ChangedLinesGutterItem(changeTrackPanel, sqlEntry, delta);
    }

    private static GutterItem createAddedLinesGutterItem(ISQLEntryPanel sqlEntry, ChangeTrackPanel changeTrackPanel, InsertDelta<String> delta) {
        return new AddedLinesGutterItem(changeTrackPanel, sqlEntry, delta);
    }
}

