/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.filemanager.IFileEditorAPI;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.CursorHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GutterItem;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GutterItemsProvider;

public class GutterItemsManager {
    private final GutterItemsProvider _gutterItemsProvider;
    private List<GutterItem> _currentGutterItems = new ArrayList<GutterItem>();
    private CursorHandler _cursorHandler = new CursorHandler();
    private ChangeTrackPanel _changeTrackPanel;

    public GutterItemsManager(ISQLEntryPanel sqlEntry, ChangeTrackPanel changeTrackPanel, IFileEditorAPI fileEditorAPI) {
        this._changeTrackPanel = changeTrackPanel;
        this._gutterItemsProvider = new GutterItemsProvider(sqlEntry, changeTrackPanel, fileEditorAPI, gi -> this.onNewGutterItems(gi));
    }

    private void onNewGutterItems(List<GutterItem> gi) {
        this._currentGutterItems = gi;
        this._changeTrackPanel.requestGutterRepaint();
    }

    public List<GutterItem> getLeftGutterItems() {
        return this._currentGutterItems;
    }

    public void leftGutterMousePressed(MouseEvent e, JPanel trackingGutterLeft) {
        this._currentGutterItems.forEach(gi -> gi.leftShowPopupIfHit(e, trackingGutterLeft));
    }

    public void leftGutterMouseMoved(MouseEvent e, JPanel trackingGutterLeft) {
        this._cursorHandler.reset();
        this._currentGutterItems.forEach(gi -> gi.leftGutterMouseMoved(e, this._cursorHandler));
        if (this._cursorHandler.isClickable()) {
            trackingGutterLeft.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            trackingGutterLeft.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void rightGutterMousePressed(MouseEvent e) {
        this._currentGutterItems.forEach(gi -> gi.rightMoveCursorWhenHit(e));
    }

    public void rightGutterMouseMoved(MouseEvent e, JPanel trackingGutterRight) {
        this._cursorHandler.reset();
        this._currentGutterItems.forEach(gi -> gi.rightGutterMouseMoved(e, this._cursorHandler));
        if (this._cursorHandler.isClickable()) {
            trackingGutterRight.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            trackingGutterRight.setCursor(Cursor.getDefaultCursor());
        }
    }

    public boolean hasChanges() {
        return 0 < this._currentGutterItems.size();
    }

    public GutterItemsProvider getGutterItemsProvider() {
        return this._gutterItemsProvider;
    }
}

