/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileHandlerListener;
import net.sourceforge.squirrel_sql.client.session.filemanager.IFileEditorAPI;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackTypeEnum;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GitHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GutterItem;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GutterItemsCreator;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GutterItemsProviderListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.RebaseGutterItemsCallInfo;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class GutterItemsProvider {
    private ChangeTrackTypeEnum _currentChangeTrackType = ChangeTrackTypeEnum.getPreference();
    private Timer _changeTrackingTrigger;
    private ExecutorService _changeTrackingExecutorService = Executors.newSingleThreadExecutor();
    private volatile boolean _changeTrackingIsBeingExecuted;
    private final ISQLEntryPanel _sqlEntry;
    private final ChangeTrackPanel _changeTrackPanel;
    private IFileEditorAPI _fileEditorAPI;
    private GutterItemsProviderListener _gutterItemsProviderListener;
    private String _changeTrackBase;
    private FileHandlerListener _fileChangeListener;
    private FileHandlerListener _gitFileChangeListener;

    public GutterItemsProvider(ISQLEntryPanel sqlEntry, ChangeTrackPanel changeTrackPanel, IFileEditorAPI fileEditorAPI, GutterItemsProviderListener gutterItemsProviderListener) {
        this._sqlEntry = sqlEntry;
        this._changeTrackPanel = changeTrackPanel;
        this._fileEditorAPI = fileEditorAPI;
        this._gutterItemsProviderListener = gutterItemsProviderListener;
        this._changeTrackingTrigger = new Timer(300, e -> this.onTriggerChangeTracking());
        this._changeTrackingTrigger.setRepeats(false);
        sqlEntry.getTextComponent().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                GutterItemsProvider.this.triggerChangeTracking();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GutterItemsProvider.this.triggerChangeTracking();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                GutterItemsProvider.this.triggerChangeTracking();
            }
        });
        this._fileChangeListener = newChangeTrackBase -> this.updateChangeTrackBase(newChangeTrackBase);
        this._gitFileChangeListener = newChangeTrackBase -> this.updateGitChangeTracking(false);
        this.rebaseGutterItems(RebaseGutterItemsCallInfo.BUTTON_SELECTED);
    }

    public void rebaseGutterItems(RebaseGutterItemsCallInfo callInfo) {
        switch (this._currentChangeTrackType) {
            case MANUAL: {
                this._fileEditorAPI.getFileHandler().setFileHandlerListener(null);
                if (callInfo != RebaseGutterItemsCallInfo.BUTTON_CLICKED) break;
                this.updateChangeTrackBase(this._fileEditorAPI.getText());
                break;
            }
            case FILE: {
                this._fileEditorAPI.getFileHandler().setFileHandlerListener(this._fileChangeListener);
                break;
            }
            case GIT: {
                this._fileEditorAPI.getFileHandler().setFileHandlerListener(this._gitFileChangeListener);
                this.updateGitChangeTracking(callInfo == RebaseGutterItemsCallInfo.BUTTON_CLICKED);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ChangeTrackType: " + this._changeTrackBase);
            }
        }
    }

    public ChangeTrackTypeEnum getChangeTrackType() {
        return this._currentChangeTrackType;
    }

    public void rebaseChangeTrackingOnToolbarButtonOrMenu() {
        this.rebaseGutterItems(RebaseGutterItemsCallInfo.BUTTON_CLICKED);
    }

    public void changeTrackTypeChanged(ChangeTrackTypeEnum selectedType) {
        this._currentChangeTrackType = selectedType;
        this.rebaseGutterItems(RebaseGutterItemsCallInfo.BUTTON_SELECTED);
    }

    public String getChangeTrackBase() {
        return this._changeTrackBase;
    }

    public void rebaseChangeTrackingBy(String newChangeTrackBase) {
        this.updateChangeTrackBase(newChangeTrackBase);
    }

    private void updateGitChangeTracking(boolean commitToGit) {
        String gitChangeTrackBase = GitHandler.getChangeTrackBaseFromGit(this._fileEditorAPI, commitToGit);
        this.updateChangeTrackBase(gitChangeTrackBase);
    }

    private void updateChangeTrackBase(String newChangeTrackBase) {
        this._changeTrackBase = newChangeTrackBase;
        this.triggerChangeTracking();
    }

    private void triggerChangeTracking() {
        this._changeTrackingTrigger.restart();
    }

    private void onTriggerChangeTracking() {
        if (this._changeTrackingIsBeingExecuted) {
            this._changeTrackingTrigger.restart();
            return;
        }
        this._changeTrackingIsBeingExecuted = true;
        this._changeTrackingExecutorService.submit(() -> this.onRunChangeTrackTask());
    }

    private void onRunChangeTrackTask() {
        try {
            List<GutterItem> gutterItems = GutterItemsCreator.createGutterItems(this._sqlEntry, this._changeTrackPanel, this._changeTrackBase);
            SwingUtilities.invokeLater(() -> this._gutterItemsProviderListener.updateGutterItems(gutterItems));
        }
        catch (Throwable t) {
            SwingUtilities.invokeLater(() -> {
                throw Utilities.wrapRuntime(t);
            });
        }
        finally {
            this._changeTrackingIsBeingExecuted = false;
        }
    }
}

