/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GitRepoTreeDirWrapper;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SelectGitRepoRootDirController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SelectGitRepoRootDirController.class);
    private JDialog _dlg;
    private JTree _tree;
    private boolean _ok;

    public File getDir(File fileToCommitToGit) {
        this.createUI(fileToCommitToGit);
        GUIUtils.initLocation(this._dlg, 300, 300);
        GUIUtils.enableCloseByEscape(this._dlg);
        this.initTree(fileToCommitToGit.getParentFile());
        this._dlg.setVisible(true);
        if (!this._ok) {
            return null;
        }
        DefaultMutableTreeNode selLeave = (DefaultMutableTreeNode)this._tree.getSelectionPath().getLastPathComponent();
        if (selLeave == null) {
            return null;
        }
        return ((GitRepoTreeDirWrapper)selLeave.getUserObject()).getFile();
    }

    private void initTree(File startDir) {
        this._tree.setRootVisible(false);
        ArrayList<File> dirs = new ArrayList<File>();
        for (File dir = startDir; null != dir; dir = dir.getParentFile()) {
            dirs.add(0, dir);
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._tree.getModel().getRoot();
        root.removeAllChildren();
        DefaultMutableTreeNode curNode = root;
        for (File file : dirs) {
            DefaultMutableTreeNode buf = new DefaultMutableTreeNode(new GitRepoTreeDirWrapper(file));
            curNode.add(buf);
            curNode = buf;
        }
        ((DefaultTreeModel)this._tree.getModel()).nodeStructureChanged((TreeNode)this._tree.getModel().getRoot());
        Object[] path = ((DefaultTreeModel)this._tree.getModel()).getPathToRoot(curNode);
        this._tree.expandPath(new TreePath(path));
        this._tree.setSelectionPath(new TreePath(path));
        ImageIcon icon = Main.getApplication().getResources().getIcon("dir_obj");
        ((DefaultTreeCellRenderer)this._tree.getCellRenderer()).setClosedIcon(icon);
        ((DefaultTreeCellRenderer)this._tree.getCellRenderer()).setOpenIcon(icon);
        ((DefaultTreeCellRenderer)this._tree.getCellRenderer()).setLeafIcon(icon);
    }

    private void onCancel() {
        this.close();
    }

    private void close() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private void onOk() {
        this._ok = true;
        this.close();
    }

    private void createUI(File fileToCommitToGit) {
        this._dlg = new JDialog(Main.getApplication().getMainFrame(), s_stringMgr.getString("SelectGitRepoRootDirController.title"), true);
        this._dlg.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        this._dlg.getContentPane().add((Component)new MultipleLineLabel(s_stringMgr.getString("SelectGitRepoRootDirController.description", fileToCommitToGit.getAbsolutePath())), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        this._tree = new JTree();
        this._dlg.getContentPane().add((Component)new JScrollPane(this._tree), gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0);
        this._dlg.getContentPane().add((Component)this.createButtonPanel(), gbc);
    }

    private JPanel createButtonPanel() {
        JPanel ret = new JPanel(new FlowLayout(1, 5, 5));
        JButton btnOk = new JButton(s_stringMgr.getString("SelectGitRepoRootDirController.ok"));
        ret.add(btnOk);
        btnOk.addActionListener(e -> this.onOk());
        JButton btnCancel = new JButton(s_stringMgr.getString("SelectGitRepoRootDirController.cancel"));
        ret.add(btnCancel);
        btnCancel.addActionListener(e -> this.onCancel());
        return ret;
    }
}

