/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist;

import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackCloseDispatcher;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackCloseListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GitHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist.RevisionListControllerChannel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist.RevisionListDialog;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist.RevisionWrapper;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist.diff.DiffToLocalCtrl;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist.diff.RevisionsDiffCtrl;
import net.sourceforge.squirrel_sql.fw.gui.ClipboardUtil;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class RevisionListController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RevisionListController.class);
    private static final String PREF_KEY_SPLIT_DIVIDER_LOCATION = "changetrack.RevisionListController.split.divider.location";
    private final DiffToLocalCtrl _diffToLocalCtrl;
    private final RevisionsDiffCtrl _revisionsDiffCtrl;
    private RevisionListDialog _dlg;
    private ChangeTrackCloseDispatcher _changeTrackCloseDispatcher;
    private RevisionListControllerChannel _revisionListControllerChannel;
    private File _file;
    private ChangeTrackCloseListener _changeTrackCloseListener;

    public RevisionListController(JComponent parentComp, ChangeTrackCloseDispatcher changeTrackCloseDispatcher, RevisionListControllerChannel revisionListControllerChannel, File file) {
        this._file = file;
        this._diffToLocalCtrl = new DiffToLocalCtrl(revisionListControllerChannel);
        this._revisionsDiffCtrl = new RevisionsDiffCtrl();
        this._dlg = new RevisionListDialog(parentComp, this._file.getName(), GitHandler.getPathRelativeToRepo(file), GitHandler.getFilesRepositoryWorkTreePath(file), this._diffToLocalCtrl.getDiffPanel(), this._revisionsDiffCtrl.getDiffPanel());
        this._changeTrackCloseDispatcher = changeTrackCloseDispatcher;
        this._revisionListControllerChannel = revisionListControllerChannel;
        this._changeTrackCloseListener = () -> this.onChangeTrackClosed();
        this._changeTrackCloseDispatcher.addChangeTrackCloseListener(this._changeTrackCloseListener);
        List<RevisionWrapper> revisions = GitHandler.getRevisions(file);
        this._dlg.lstRevisions.setListData((RevisionWrapper[])revisions.toArray(new RevisionWrapper[0]));
        this._dlg.lstRevisions.setSelectionMode(2);
        if (0 < revisions.size()) {
            this._dlg.lstRevisions.setSelectedIndex(0);
            this._dlg.lstRevisions.ensureIndexIsVisible(0);
        }
        this._dlg.lstRevisions.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RevisionListController.this.maybeShowRevisionListPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                RevisionListController.this.maybeShowRevisionListPopup(e);
            }
        });
        this._dlg.txtPreview.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RevisionListController.this.maybeShowPreviewPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                RevisionListController.this.maybeShowPreviewPopup(e);
            }
        });
        this._dlg.tabbedPane.addChangeListener(e -> this.onTabChanged());
        GUIUtils.initLocation(this._dlg, 500, 500);
        GUIUtils.enableCloseByEscape(this._dlg, dialog -> this.onCloseRevisionList());
        this.initSplitDividerLocation();
        this._dlg.lstRevisions.addListSelectionListener(e -> this.onListSelectionChanged(e));
        this.onListSelectionChanged(null);
        this._dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RevisionListController.this.onCloseRevisionList();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                RevisionListController.this.onCloseRevisionList();
            }
        });
        this._dlg.setVisible(true);
    }

    private void onTabChanged() {
        this.cleanUpMelds();
        if (this._dlg.tabbedPane.getSelectedComponent() == this._diffToLocalCtrl.getDiffPanel() && 1 == this._dlg.lstRevisions.getSelectedValuesList().size()) {
            RevisionWrapper selectedWrapper = this._dlg.lstRevisions.getSelectedValue();
            String fileContent = GitHandler.getVersionOfFile(this._file, selectedWrapper.getRevCommitId(), selectedWrapper.getPreviousNamesOfFileRelativeToRepositoryRoot());
            this._diffToLocalCtrl.setSelectedRevision(fileContent, selectedWrapper.getRevisionDateString());
        } else if (this._dlg.tabbedPane.getSelectedComponent() == this._revisionsDiffCtrl.getDiffPanel() && 1 < this._dlg.lstRevisions.getSelectedValuesList().size()) {
            RevisionWrapper leftWrapper = this._dlg.lstRevisions.getSelectedValuesList().get(0);
            RevisionWrapper rightWrapper = this._dlg.lstRevisions.getSelectedValuesList().get(1);
            String fileContentLeft = GitHandler.getVersionOfFile(this._file, leftWrapper.getRevCommitId(), leftWrapper.getPreviousNamesOfFileRelativeToRepositoryRoot());
            String fileContentRight = GitHandler.getVersionOfFile(this._file, rightWrapper.getRevCommitId(), rightWrapper.getPreviousNamesOfFileRelativeToRepositoryRoot());
            this._revisionsDiffCtrl.setSelectedRevisions(fileContentLeft, leftWrapper.getRevisionDateString(), fileContentRight, rightWrapper.getRevisionDateString());
        }
    }

    private void onCloseRevisionList() {
        this.saveSplitLocation();
        this.cleanUpMelds();
    }

    private void cleanUpMelds() {
        this._diffToLocalCtrl.cleanUpMelds();
        this._revisionsDiffCtrl.cleanUpMelds();
    }

    private void maybeShowPreviewPopup(MouseEvent me) {
        if (!me.isPopupTrigger()) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem mnuPreviewCopy = new JMenuItem(s_stringMgr.getString("RevisionListController.preview.copy"));
        mnuPreviewCopy.addActionListener(e -> ClipboardUtil.copyToClip(this._dlg.txtPreview.getSelectedText(), true));
        popupMenu.add(mnuPreviewCopy);
        JMenuItem mnuPreviewCopyAll = new JMenuItem(s_stringMgr.getString("RevisionListController.preview.copy.all"));
        mnuPreviewCopyAll.addActionListener(e -> ClipboardUtil.copyToClip(this._dlg.txtPreview.getText(), true));
        popupMenu.add(mnuPreviewCopyAll);
        popupMenu.show(this._dlg.txtPreview, me.getX(), me.getY());
    }

    private void onChangeTrackClosed() {
        this._changeTrackCloseDispatcher.removeChangeTrackCloseListener(this._changeTrackCloseListener);
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private void saveSplitLocation() {
        Main.getApplication().getPropsImpl().put(PREF_KEY_SPLIT_DIVIDER_LOCATION, this._dlg.splitTreePreview.getDividerLocation());
    }

    private void onListSelectionChanged(ListSelectionEvent e) {
        if (null != e && e.getValueIsAdjusting()) {
            return;
        }
        this.cleanUpMelds();
        this._dlg.txtPreview.setText(null);
        this._diffToLocalCtrl.setSelectedRevision(null, null);
        if (this._dlg.lstRevisions.getSelectedValuesList().isEmpty()) {
            this._dlg.tabbedPane.setEnabledAt(0, true);
            this._dlg.tabbedPane.setEnabledAt(1, true);
            this._dlg.tabbedPane.setEnabledAt(2, false);
            if (2 == this._dlg.tabbedPane.getSelectedIndex()) {
                this._dlg.tabbedPane.setSelectedIndex(0);
            }
        } else if (1 == this._dlg.lstRevisions.getSelectedValuesList().size()) {
            this._dlg.tabbedPane.setEnabledAt(0, true);
            this._dlg.tabbedPane.setEnabledAt(1, true);
            this._dlg.tabbedPane.setEnabledAt(2, false);
            if (2 == this._dlg.tabbedPane.getSelectedIndex()) {
                this._dlg.tabbedPane.setSelectedIndex(0);
            }
            RevisionWrapper selectedWrapper = this._dlg.lstRevisions.getSelectedValuesList().get(0);
            String fileContent = GitHandler.getVersionOfFile(this._file, selectedWrapper.getRevCommitId(), selectedWrapper.getPreviousNamesOfFileRelativeToRepositoryRoot());
            this._dlg.txtPreview.setText(fileContent);
            if (this._dlg.tabbedPane.getSelectedComponent() == this._diffToLocalCtrl.getDiffPanel()) {
                this._diffToLocalCtrl.setSelectedRevision(fileContent, selectedWrapper.getRevisionDateString());
            }
            SwingUtilities.invokeLater(() -> this._dlg.txtPreview.scrollRectToVisible(new Rectangle(0, 0, 1, 1)));
        } else {
            this._dlg.tabbedPane.setEnabledAt(0, false);
            this._dlg.tabbedPane.setEnabledAt(1, false);
            this._dlg.tabbedPane.setEnabledAt(2, true);
            this._dlg.tabbedPane.setSelectedIndex(2);
            RevisionWrapper leftWrapper = this._dlg.lstRevisions.getSelectedValuesList().get(0);
            RevisionWrapper rightWrapper = this._dlg.lstRevisions.getSelectedValuesList().get(1);
            String fileContentLeft = GitHandler.getVersionOfFile(this._file, leftWrapper.getRevCommitId(), leftWrapper.getPreviousNamesOfFileRelativeToRepositoryRoot());
            String fileContentRight = GitHandler.getVersionOfFile(this._file, rightWrapper.getRevCommitId(), rightWrapper.getPreviousNamesOfFileRelativeToRepositoryRoot());
            this._revisionsDiffCtrl.setSelectedRevisions(fileContentLeft, leftWrapper.getRevisionDateString(), fileContentRight, rightWrapper.getRevisionDateString());
        }
    }

    private void initSplitDividerLocation() {
        int preferredDividerLocation;
        int dividerLocation = preferredDividerLocation = Main.getApplication().getPropsImpl().getInt(PREF_KEY_SPLIT_DIVIDER_LOCATION, this._dlg.getWidth() / 2);
        if (0 < this._dlg.splitTreePreview.getWidth()) {
            dividerLocation = Math.min(this._dlg.splitTreePreview.getMaximumDividerLocation(), preferredDividerLocation);
        }
        this._dlg.splitTreePreview.setDividerLocation(dividerLocation);
    }

    private void maybeShowRevisionListPopup(MouseEvent me) {
        if (!me.isPopupTrigger()) {
            return;
        }
        int ix = this._dlg.lstRevisions.locationToIndex(me.getPoint());
        if (ix < 0) {
            return;
        }
        this._dlg.lstRevisions.setSelectedIndex(ix);
        JPopupMenu popupMenu = new JPopupMenu();
        JMenu mnuCopy = new JMenu(s_stringMgr.getString("RevisionListController.copy"));
        RevisionWrapper selectedWrapper = this._dlg.lstRevisions.getSelectedValue();
        mnuCopy.add(this.createCopyMenu("RevisionListController.copy.all", selectedWrapper.getDisplayString()));
        mnuCopy.add(this.createCopyMenu("RevisionListController.copy.date", selectedWrapper.getRevisionDateString()));
        mnuCopy.add(this.createCopyMenu("RevisionListController.copy.brancheslist", selectedWrapper.getBranchesListString()));
        mnuCopy.add(this.createCopyMenu("RevisionListController.copy.user", selectedWrapper.getCommitterName()));
        mnuCopy.add(this.createCopyMenu("RevisionListController.copy.revid", selectedWrapper.getRevisionIdString()));
        mnuCopy.add(this.createCopyMenu("RevisionListController.copy.commitMsg", selectedWrapper.getCommitMsg()));
        popupMenu.add(mnuCopy);
        JMenuItem mnuAsChangeTrackBase = new JMenuItem(s_stringMgr.getString("RevisionListController.as.change.track.base"));
        mnuAsChangeTrackBase.addActionListener(e -> this._revisionListControllerChannel.replaceChangeTrackBase(this._dlg.txtPreview.getText()));
        popupMenu.add(mnuAsChangeTrackBase);
        JMenuItem mnuAsEditorContent = new JMenuItem(s_stringMgr.getString("RevisionListController.as.editor.content"));
        mnuAsEditorContent.addActionListener(e -> this._revisionListControllerChannel.replaceEditorContent(this._dlg.txtPreview.getText()));
        popupMenu.add(mnuAsEditorContent);
        popupMenu.show(this._dlg.lstRevisions, me.getX(), me.getY());
    }

    private JMenuItem createCopyMenu(String title, String toCopy) {
        JMenuItem ret = new JMenuItem(s_stringMgr.getString(title));
        ret.addActionListener(e -> ClipboardUtil.copyToClip(toCopy));
        return ret;
    }
}

