/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist;

import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;

public class RevisionWrapper {
    private String _revisionDateString;
    private String _branchesListString;
    private String _committerName;
    private String _revisionIdString;
    private String _commitMsg;
    private ObjectId _revCommitId;
    private boolean _headRevision;
    private HashSet<String> _previousNamesOfFileRelativeToRepositoryRoot;

    public RevisionWrapper(RevCommit revCommit, Git git, ObjectId headCommitId, HashSet<String> previousNamesOfFileRelativeToRepositoryRoot) {
        try {
            this._revisionDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(revCommit.getAuthorIdent().getWhen());
            this._branchesListString = String.join((CharSequence)"; ", git.branchList().setContains(revCommit.getId().getName()).call().stream().map(b -> b.getName()).collect(Collectors.toList()));
            this._committerName = revCommit.getAuthorIdent().getName() + "; Mail: " + revCommit.getAuthorIdent().getEmailAddress();
            this._revisionIdString = revCommit.getId().getName();
            this._commitMsg = revCommit.getFullMessage();
            this._revCommitId = revCommit.toObjectId();
            this._headRevision = headCommitId.equals((AnyObjectId)this._revCommitId);
            this._previousNamesOfFileRelativeToRepositoryRoot = previousNamesOfFileRelativeToRepositoryRoot;
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    boolean isHeadRevision() {
        return this._headRevision;
    }

    public String getRevisionDateString() {
        return this._revisionDateString;
    }

    public String getBranchesListString() {
        return this._branchesListString;
    }

    public String getCommitterName() {
        return this._committerName;
    }

    public String getRevisionIdString() {
        return this._revisionIdString;
    }

    public String getCommitMsgBegin() {
        return this.firstTwoLines(this._commitMsg);
    }

    public String getCommitMsg() {
        return this._commitMsg;
    }

    public ObjectId getRevCommitId() {
        return this._revCommitId;
    }

    public HashSet<String> getPreviousNamesOfFileRelativeToRepositoryRoot() {
        return this._previousNamesOfFileRelativeToRepositoryRoot;
    }

    private String firstTwoLines(String fullMessage) {
        Object ret = "";
        String[] splits = fullMessage.split("\n");
        for (int i = 0; i < splits.length; ++i) {
            ret = i == 0 ? splits[i] : (String)ret + "\n" + splits[i];
            if (i < 1) continue;
            return (String)ret + " ...";
        }
        return ret;
    }

    public String getDisplayString() {
        return this._revisionDateString + "\n  Branches: " + this._branchesListString + "\n  User: " + this._committerName + "\n  Revision-Id: " + this._revisionIdString + "\n  Msg: " + this.getCommitMsgBegin();
    }
}

