/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist.diff;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class DiffFileUtil {
    static Path createSqlEditorContentTempFile(String editorContent) {
        return DiffFileUtil.createTempFile(editorContent, "SQuirreLSQL.changeTrack.revisionList.sqlEditor");
    }

    static Path createGitRevisionTempFile(String gitRevision) {
        return DiffFileUtil.createTempFile(gitRevision, "SQuirreLSQL.changeTrack.revisionList.gitRevision");
    }

    private static Path createTempFile(String contentText, String fileNamePrefix) {
        try {
            Path leftFile = Files.createTempFile(fileNamePrefix, ".sql", new FileAttribute[0]);
            leftFile.toFile().deleteOnExit();
            return Files.write(leftFile, contentText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw Utilities.wrapRuntime(e);
        }
    }
}

