/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist.diff;

import java.awt.Component;
import java.nio.file.Path;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.gui.JMeldCore;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist.RevisionListControllerChannel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist.diff.DiffFileUtil;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist.diff.DiffPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DiffToLocalCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DiffToLocalCtrl.class);
    private final RevisionListControllerChannel _revisionListControllerChannel;
    private final JMeldCore _meldCore;
    private DiffPanel _diffPanel;

    public DiffToLocalCtrl(RevisionListControllerChannel revisionListControllerChannel) {
        this._revisionListControllerChannel = revisionListControllerChannel;
        this._meldCore = new JMeldCore(true);
        this._diffPanel = new DiffPanel(this._meldCore.getConfigurableMeldPanel());
    }

    public DiffPanel getDiffPanel() {
        return this._diffPanel;
    }

    public void setSelectedRevision(String gitRevisionContent, String revisionDateString) {
        this._diffPanel.pnlDiffContainer.removeAll();
        if (null == gitRevisionContent) {
            this._diffPanel.lblLeftTitle.setText(s_stringMgr.getString("DiffToLocalCtrl.no.revision.selected.short"));
            JTextArea txt = new JTextArea();
            txt.setText(s_stringMgr.getString("DiffToLocalCtrl.no.revision.selected"));
            txt.setEditable(false);
            txt.setBorder(BorderFactory.createEtchedBorder());
            this._diffPanel.pnlDiffContainer.add(new JScrollPane(txt));
            return;
        }
        this._diffPanel.lblLeftTitle.setText(s_stringMgr.getString("DiffToLocalCtrl.revision.date", revisionDateString));
        this._diffPanel.lblRightTitle.setText(s_stringMgr.getString("DiffToLocalCtrl.sqlEditor"));
        Path sqlEditorContentTempFile = DiffFileUtil.createSqlEditorContentTempFile(this._revisionListControllerChannel.getEditorContent());
        Path gitRevisionContentTempFile = DiffFileUtil.createGitRevisionTempFile(gitRevisionContent);
        this._meldCore.executeDiff(gitRevisionContentTempFile.toFile().getAbsolutePath(), sqlEditorContentTempFile.toFile().getAbsolutePath(), null, text -> this._revisionListControllerChannel.replaceEditorContent(text));
        this._diffPanel.pnlDiffContainer.add((Component)this._meldCore.getConfigurableMeldPanel().getMeldPanel());
    }

    public void cleanUpMelds() {
        this._meldCore.cleanMeldPanel();
    }
}

