/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist.diff;

import java.awt.Component;
import java.nio.file.Path;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.gui.JMeldCore;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist.diff.DiffFileUtil;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist.diff.DiffPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.revisionlist.diff.DiffToLocalCtrl;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class RevisionsDiffCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DiffToLocalCtrl.class);
    private DiffPanel _diffPanel;
    private JMeldCore _meldCore = new JMeldCore(true);

    public RevisionsDiffCtrl() {
        this._diffPanel = new DiffPanel(this._meldCore.getConfigurableMeldPanel());
    }

    public DiffPanel getDiffPanel() {
        return this._diffPanel;
    }

    public void setSelectedRevisions(String leftGitRevisionContent, String leftRevisionDateString, String rightGitRevisionContent, String rightRevisionDateString) {
        this._diffPanel.pnlDiffContainer.removeAll();
        this._diffPanel.lblLeftTitle.setText(s_stringMgr.getString("RevisionsDiffCtrl.revision.date", leftRevisionDateString));
        this._diffPanel.lblRightTitle.setText(s_stringMgr.getString("RevisionsDiffCtrl.revision.date", rightRevisionDateString));
        Path gitRevisionContentTempFileLeft = DiffFileUtil.createGitRevisionTempFile(leftGitRevisionContent);
        Path gitRevisionContentTempFileRight = DiffFileUtil.createGitRevisionTempFile(rightGitRevisionContent);
        this._meldCore.executeDiff(gitRevisionContentTempFileLeft.toFile().getAbsolutePath(), gitRevisionContentTempFileRight.toFile().getAbsolutePath(), null, null);
        this._diffPanel.pnlDiffContainer.add((Component)this._meldCore.getConfigurableMeldPanel().getMeldPanel());
    }

    public void cleanUpMelds() {
        this._meldCore.cleanMeldPanel();
    }
}

