/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.findresultcolumn;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.findresultcolumn.ColumnCopyHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.findresultcolumn.ColumnSortingEnum;
import net.sourceforge.squirrel_sql.client.session.mainpanel.findresultcolumn.FindColumnColWrapper;
import net.sourceforge.squirrel_sql.client.session.mainpanel.findresultcolumn.FindResultColumnDlg;
import net.sourceforge.squirrel_sql.client.session.mainpanel.findresultcolumn.TableNameAccess;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanelUtil;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class FindResultColumnCtrl {
    public static final String PREF_KEY_FIND_COLUMN_SHEET_WIDTH = "Squirrel.findColumnSheet.width";
    public static final String PREF_KEY_FIND_COLUMN_SHEET_HEIGHT = "Squirrel.findColumnSheet.height";
    public static final String PREF_KEY_FIND_IN_TABLE_NAME = "Squirrel.findColumnSheet.find.in.table.name";
    private final DataSetViewerTablePanel _dataSetViewerTablePanel;
    private final FindResultColumnDlg _findResultColumnDlg;
    private final DefaultListModel<FindColumnColWrapper> _leftListModel = new DefaultListModel();
    private final DefaultListModel<FindColumnColWrapper> _rightListModel = new DefaultListModel();
    private ColumnSortingEnum _columnSorting = ColumnSortingEnum.NONE;
    private FindColumnColWrapper _columnToGoTo;
    private ArrayList<ExtTableColumn> _columnsToMoveToFront;
    private final boolean _dataSetContainsdifferentTables;

    public FindResultColumnCtrl(Window owningWindow, DataSetViewerTablePanel dataSetViewerTablePanel) {
        this._dataSetContainsdifferentTables = this.dataSetContainsdifferentTables(dataSetViewerTablePanel);
        this._dataSetViewerTablePanel = dataSetViewerTablePanel;
        this._findResultColumnDlg = new FindResultColumnDlg(owningWindow);
        this._findResultColumnDlg.chkFindInTableNames.setSelected(Props.getBoolean(PREF_KEY_FIND_IN_TABLE_NAME, false));
        this._findResultColumnDlg.chkFindInTableNames.setEnabled(this._dataSetContainsdifferentTables);
        this._findResultColumnDlg.chkFindInTableNames.addActionListener(e -> this.onFindInTableNames());
        this._findResultColumnDlg.lstLeft.setModel(this._leftListModel);
        this._findResultColumnDlg.lstLeft.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FindResultColumnCtrl.this.onMouseClicked(e);
            }
        });
        this._findResultColumnDlg.lstRight.setModel(this._rightListModel);
        this._findResultColumnDlg.lstLeft.addMouseListener(ColumnCopyHandler.getListPopupListener(this._findResultColumnDlg.lstLeft));
        this._findResultColumnDlg.lstRight.addMouseListener(ColumnCopyHandler.getListPopupListener(this._findResultColumnDlg.lstRight));
        this._findResultColumnDlg.btnSortAsc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindResultColumnCtrl.this._columnSorting = ColumnSortingEnum.ASC;
                FindResultColumnCtrl.this.onFilterChanged();
            }
        });
        this._findResultColumnDlg.btnSortDesc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindResultColumnCtrl.this._columnSorting = ColumnSortingEnum.DESC;
                FindResultColumnCtrl.this.onFilterChanged();
            }
        });
        this._findResultColumnDlg.txtFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FindResultColumnCtrl.this.onFilterChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FindResultColumnCtrl.this.onFilterChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FindResultColumnCtrl.this.onFilterChanged();
            }
        });
        this._findResultColumnDlg.btnRight.addActionListener(e -> this.onMoveRight());
        this._findResultColumnDlg.btnLeft.addActionListener(e -> this.onMoveLeft());
        this._findResultColumnDlg.btnUp.addActionListener(e -> this.onMoveUp());
        this._findResultColumnDlg.btnDown.addActionListener(e -> this.onMoveDown());
        this._findResultColumnDlg.btnToTableBegin.addActionListener(e -> this.onMoveToTableBegin());
        this.onFilterChanged();
        GUIUtils.enableCloseByEscape(this._findResultColumnDlg, dialog -> this.onClosing());
        this._findResultColumnDlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FindResultColumnCtrl.this.onClosing();
            }
        });
        this._findResultColumnDlg.setSize(this.getDimension());
        this._findResultColumnDlg.showDialog();
    }

    private void onFindInTableNames() {
        Props.putBoolean(PREF_KEY_FIND_IN_TABLE_NAME, this._findResultColumnDlg.chkFindInTableNames.isSelected());
        this.onFilterChanged();
    }

    private boolean dataSetContainsdifferentTables(DataSetViewerTablePanel dataSetViewerTablePanel) {
        HashSet<String> uniqueTableNamesOrNull = new HashSet<String>();
        for (ExtTableColumn extTableColumn : DataSetViewerTablePanelUtil.getTableColumns(dataSetViewerTablePanel.getTable())) {
            uniqueTableNamesOrNull.add(TableNameAccess.getTableName(extTableColumn));
        }
        return uniqueTableNamesOrNull.size() > 1;
    }

    private void onMoveToTableBegin() {
        this._columnsToMoveToFront = new ArrayList();
        for (int i = 0; i < this._rightListModel.size(); ++i) {
            FindColumnColWrapper wrapper = this._rightListModel.get(i);
            this._columnsToMoveToFront.add(wrapper.getExtTableColumn());
        }
        this.close();
    }

    private void onMoveUp() {
        int[] selIx = this._findResultColumnDlg.lstRight.getSelectedIndices();
        if (null == selIx || 0 == selIx.length) {
            return;
        }
        for (int i : selIx) {
            if (0 != i) continue;
            return;
        }
        int[] newSelIx = new int[selIx.length];
        for (int i = 0; i < selIx.length; ++i) {
            FindColumnColWrapper item = this._rightListModel.remove(selIx[i]);
            newSelIx[i] = selIx[i] - 1;
            this._rightListModel.insertElementAt(item, newSelIx[i]);
        }
        this._findResultColumnDlg.lstRight.setSelectedIndices(newSelIx);
        this._findResultColumnDlg.lstRight.ensureIndexIsVisible(newSelIx[0]);
    }

    private void onMoveDown() {
        int[] selIx = this._findResultColumnDlg.lstRight.getSelectedIndices();
        if (null == selIx || 0 == selIx.length) {
            return;
        }
        for (int i : selIx) {
            if (this._rightListModel.getSize() - 1 != i) continue;
            return;
        }
        int[] newSelIx = new int[selIx.length];
        for (int i = selIx.length - 1; i >= 0; --i) {
            FindColumnColWrapper item = this._rightListModel.remove(selIx[i]);
            newSelIx[i] = selIx[i] + 1;
            this._rightListModel.insertElementAt(item, newSelIx[i]);
        }
        this._findResultColumnDlg.lstRight.setSelectedIndices(newSelIx);
        this._findResultColumnDlg.lstRight.ensureIndexIsVisible(newSelIx[newSelIx.length - 1]);
    }

    private void onMoveRight() {
        this._findResultColumnDlg.lstRight.clearSelection();
        for (FindColumnColWrapper findColumnColWrapper : this._findResultColumnDlg.lstLeft.getSelectedValuesList()) {
            this._leftListModel.removeElement(findColumnColWrapper);
            this._rightListModel.addElement(findColumnColWrapper);
            this._findResultColumnDlg.lstRight.addSelectionInterval(this._rightListModel.size() - 1, this._rightListModel.size() - 1);
        }
    }

    private void onMoveLeft() {
        this._findResultColumnDlg.lstLeft.clearSelection();
        for (FindColumnColWrapper findColumnColWrapper : this._findResultColumnDlg.lstRight.getSelectedValuesList()) {
            this._rightListModel.removeElement(findColumnColWrapper);
            this._leftListModel.addElement(findColumnColWrapper);
            this._findResultColumnDlg.lstLeft.addSelectionInterval(this._leftListModel.size() - 1, this._leftListModel.size() - 1);
        }
        this.onFilterChanged();
    }

    private void onFilterChanged() {
        ArrayList<FindColumnColWrapper> newListContent = new ArrayList<FindColumnColWrapper>();
        List<FindColumnColWrapper> formerSelectedValues = this._findResultColumnDlg.lstLeft.getSelectedValuesList();
        for (ExtTableColumn extTableColumn : DataSetViewerTablePanelUtil.getTableColumns(this._dataSetViewerTablePanel.getTable())) {
            FindColumnColWrapper colWrapper = new FindColumnColWrapper(extTableColumn, this._dataSetContainsdifferentTables);
            String filterText = this._findResultColumnDlg.txtFilter.getText();
            if (!StringUtilities.isEmpty(filterText, true) && -1 >= colWrapper.getMatchString(this._findResultColumnDlg.chkFindInTableNames.isSelected()).toLowerCase().indexOf(filterText.toLowerCase()) || this._rightListModel.contains(colWrapper)) continue;
            newListContent.add(colWrapper);
        }
        if (this._columnSorting == ColumnSortingEnum.ASC) {
            Collections.sort(newListContent, new Comparator<FindColumnColWrapper>(){

                @Override
                public int compare(FindColumnColWrapper o1, FindColumnColWrapper o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
        } else if (this._columnSorting == ColumnSortingEnum.DESC) {
            Collections.sort(newListContent, new Comparator<FindColumnColWrapper>(){

                @Override
                public int compare(FindColumnColWrapper o1, FindColumnColWrapper o2) {
                    return -o1.toString().compareTo(o2.toString());
                }
            });
        }
        this._leftListModel.clear();
        for (FindColumnColWrapper findColumnColWrapper : newListContent) {
            this._leftListModel.addElement(findColumnColWrapper);
        }
        this._findResultColumnDlg.lstLeft.clearSelection();
        ArrayList<Integer> indicesToSelect = new ArrayList<Integer>();
        for (FindColumnColWrapper formerSelectedValue : formerSelectedValues) {
            indicesToSelect.add(this._leftListModel.indexOf(formerSelectedValue));
        }
        for (Integer ix : indicesToSelect) {
            this._findResultColumnDlg.lstLeft.addSelectionInterval(ix, ix);
        }
    }

    private void onMouseClicked(MouseEvent e) {
        if (2 == e.getClickCount()) {
            this._columnToGoTo = this._findResultColumnDlg.lstLeft.getSelectedValue();
            if (null == this._columnToGoTo) {
                return;
            }
            this.close();
        }
    }

    private void close() {
        this.onClosing();
        this._findResultColumnDlg.setVisible(false);
        this._findResultColumnDlg.dispose();
    }

    public FindColumnColWrapper getColumnToGoTo() {
        return this._columnToGoTo;
    }

    public ArrayList<ExtTableColumn> getColumnsToMoveToFront() {
        return this._columnsToMoveToFront;
    }

    private void onClosing() {
        Props.putInt(PREF_KEY_FIND_COLUMN_SHEET_WIDTH, this._findResultColumnDlg.getWidth());
        Props.putInt(PREF_KEY_FIND_COLUMN_SHEET_HEIGHT, this._findResultColumnDlg.getHeight());
    }

    private Dimension getDimension() {
        return new Dimension(Props.getInt(PREF_KEY_FIND_COLUMN_SHEET_WIDTH, 600), Props.getInt(PREF_KEY_FIND_COLUMN_SHEET_HEIGHT, 500));
    }
}

