/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.notificationsound;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.mainpanel.notificationsound.ConfigureFinishedSoundDlg;
import net.sourceforge.squirrel_sql.client.session.mainpanel.notificationsound.SoundConfigDAO;
import net.sourceforge.squirrel_sql.client.session.mainpanel.notificationsound.SoundPlayer;
import net.sourceforge.squirrel_sql.client.session.mainpanel.notificationsound.TimeUnit;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.FileExtensionFilter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ConfigureFinishedSoundCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ConfigureFinishedSoundCtrl.class);
    private static final ILogger s_log = LoggerController.createLogger(ConfigureFinishedSoundCtrl.class);
    private static final String PREF_LAST_SOUND_FILE_DIR = "ConfigureFinishedSoundCtrl.last.sound.file.dir";
    private final ConfigureFinishedSoundDlg _dlg;
    private boolean _adjustingTestSound = false;

    public ConfigureFinishedSoundCtrl(JComponent parentComp) {
        this._dlg = new ConfigureFinishedSoundDlg(parentComp);
        this._dlg.btnOk.addActionListener(e -> this.onOk());
        this._dlg.btnCancel.addActionListener(e -> this.close());
        this._dlg.chkPLaySoundAfter.setSelected(SoundConfigDAO.isPlayNotification());
        this._dlg.chkPLaySoundAfter.addActionListener(e -> this.onchkPLaySound());
        this.onchkPLaySound();
        this._dlg.txtTime.setText("" + SoundConfigDAO.getPlayNotificationAfter());
        this._dlg.cboTimeUnit.setSelectedItem((Object)SoundConfigDAO.getTimeUnit());
        this._dlg.btnChooseSoundToPlay.addActionListener(e -> this.onChooseSoundFile());
        this._dlg.txtSoundFile.setText(SoundConfigDAO.getSoundFileAsString());
        this._dlg.btnTestSound.addActionListener(e -> this.onTestSound());
        this._dlg.setVisible(true);
    }

    private void onChooseSoundFile() {
        JFileChooser fc = new JFileChooser(Props.getString(PREF_LAST_SOUND_FILE_DIR, System.getProperty("user.home")));
        for (FileFilter choosableFileFilter : fc.getChoosableFileFilters()) {
            fc.removeChoosableFileFilter(choosableFileFilter);
        }
        FileExtensionFilter mp3Filter = new FileExtensionFilter("MP3 files", new String[]{".mp3"});
        fc.addChoosableFileFilter(mp3Filter);
        FileExtensionFilter oggFilter = new FileExtensionFilter("OGG files", new String[]{".ogg"});
        fc.addChoosableFileFilter(oggFilter);
        FileExtensionFilter wavFilter = new FileExtensionFilter("WAV files", new String[]{".wav"});
        fc.addChoosableFileFilter(wavFilter);
        fc.setFileFilter(mp3Filter);
        int returnVal = fc.showOpenDialog(this._dlg);
        if (null != fc.getCurrentDirectory()) {
            Props.putString(PREF_LAST_SOUND_FILE_DIR, fc.getCurrentDirectory().getPath());
        }
        String soundFilePath = null;
        if (returnVal == 0) {
            soundFilePath = fc.getSelectedFile().getAbsolutePath();
        }
        this._dlg.txtSoundFile.setText(soundFilePath);
    }

    private void onTestSound() {
        if (this._adjustingTestSound) {
            return;
        }
        try {
            this._adjustingTestSound = true;
            if (SoundPlayer.PLAYER.quit()) {
                this._dlg.btnTestSound.setSelected(false);
                return;
            }
            if (StringUtilities.isEmpty(this._dlg.txtSoundFile.getText(), true)) {
                this._dlg.btnTestSound.setSelected(false);
                JOptionPane.showMessageDialog(this._dlg, s_stringMgr.getString("ConfigureFinishedSoundCtrl.no.sound.file"));
                return;
            }
            Path path = Paths.get(this._dlg.txtSoundFile.getText(), new String[0]);
            if (!Files.isRegularFile(path, new LinkOption[0]) || !Files.exists(path, new LinkOption[0])) {
                this._dlg.btnTestSound.setSelected(false);
                JOptionPane.showMessageDialog(this._dlg, s_stringMgr.getString("ConfigureFinishedSoundCtrl.sound.file.does.not.exist"));
                return;
            }
            this._dlg.btnTestSound.setSelected(true);
            Thread t = new Thread(() -> this.playSound(path));
            t.start();
        }
        finally {
            this._adjustingTestSound = false;
        }
    }

    private void playSound(Path path) {
        try {
            SoundPlayer.PLAYER.play(path.toFile());
        }
        catch (Throwable e) {
            s_log.error("Error testing execution finished sound", e);
            Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("FinishedNotificationSoundHandler.error.testing.finished.sound", Utilities.getExceptionStringSave(e)));
        }
        finally {
            SwingUtilities.invokeLater(() -> this.deselectTestButton());
        }
    }

    private void deselectTestButton() {
        try {
            this._adjustingTestSound = true;
            if (this._dlg.btnTestSound.isSelected()) {
                this._dlg.btnTestSound.setSelected(false);
            }
        }
        finally {
            this._adjustingTestSound = false;
        }
    }

    private void onchkPLaySound() {
        this._dlg.txtTime.setEnabled(this._dlg.chkPLaySoundAfter.isSelected());
        this._dlg.cboTimeUnit.setEnabled(this._dlg.chkPLaySoundAfter.isSelected());
    }

    private void onOk() {
        SoundConfigDAO.setPlayNotification(this._dlg.chkPLaySoundAfter.isSelected());
        SoundConfigDAO.setPlayNotificationAfter(this._dlg.txtTime.getInt());
        SoundConfigDAO.setTimeUnit((TimeUnit)((Object)this._dlg.cboTimeUnit.getSelectedItem()));
        SoundConfigDAO.writeSoundFile(this._dlg.txtSoundFile.getText());
        this.close();
    }

    private void close() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }
}

