/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.notificationsound;

import javax.swing.JComponent;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.event.ISQLExecutionListener;
import net.sourceforge.squirrel_sql.client.session.event.SQLExecutionAdapter;
import net.sourceforge.squirrel_sql.client.session.mainpanel.notificationsound.ConfigureFinishedSoundCtrl;
import net.sourceforge.squirrel_sql.client.session.mainpanel.notificationsound.SoundConfigDAO;
import net.sourceforge.squirrel_sql.client.session.mainpanel.notificationsound.SoundPlayer;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class FinishedNotificationSoundHandler {
    private static final ILogger s_log = LoggerController.createLogger(FinishedNotificationSoundHandler.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FinishedNotificationSoundHandler.class);
    private boolean _playFinishedSoundChecked;
    private Long _playNotificationWhenMillisElapsed = SoundConfigDAO.playNotificationWhenMillisElapsed();

    public void onPlayFinishedSoundChecked(boolean b) {
        this._playFinishedSoundChecked = b;
        if (!b) {
            this._playNotificationWhenMillisElapsed = null;
        }
    }

    public void onConfigureFinishedSound(JComponent parent) {
        new ConfigureFinishedSoundCtrl(parent);
    }

    public ISQLExecutionListener getExecutionFinishedListener() {
        return new SQLExecutionAdapter(){

            @Override
            public void executionFinished() {
                FinishedNotificationSoundHandler.this.onExecutionFinished();
            }
        };
    }

    private void onExecutionFinished() {
        if (this._playFinishedSoundChecked) {
            Thread t = new Thread(() -> this.playFinishedSound());
            t.start();
        }
    }

    private void playFinishedSound() {
        try {
            SoundPlayer.PLAYER.quit();
            SoundPlayer.PLAYER.play(SoundConfigDAO.getSoundFile());
        }
        catch (Throwable e) {
            s_log.error("Error playing execution finished sound", e);
            Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("FinishedNotificationSoundHandler.error.playing.finished.sound", Utilities.getExceptionStringSave(e)));
        }
    }

    public boolean isToPlayNotificationSound(long elapsedMillis) {
        boolean ret;
        if (this._playFinishedSoundChecked) {
            return true;
        }
        if (null == this._playNotificationWhenMillisElapsed) {
            return false;
        }
        boolean bl = ret = this._playNotificationWhenMillisElapsed < elapsedMillis;
        if (ret) {
            this._playFinishedSoundChecked = true;
        }
        return ret;
    }
}

