/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.notificationsound;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrameToolBar;
import net.sourceforge.squirrel_sql.client.session.mainpanel.notificationsound.QuitSoundAction;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public enum SoundPlayer {
    PLAYER;

    private SourceDataLine _sdl;

    public synchronized void play(File soundFile) {
        try {
            if (null == soundFile) {
                this.beep();
            } else {
                this.playFile(soundFile);
            }
        }
        finally {
            this._sdl = null;
            GUIUtils.processOnSwingEventThread(() -> this.removeQuitSoundToolbarButton());
        }
    }

    private void removeQuitSoundToolbarButton() {
        MainFrameToolBar mainFrameToolBar = Main.getApplication().getMainFrame().getMainFrameToolBar();
        mainFrameToolBar.remove(Main.getApplication().getActionCollection().get(QuitSoundAction.class));
    }

    private void addQuitSoundToolbarButton() {
        MainFrameToolBar mainFrameToolBar = Main.getApplication().getMainFrame().getMainFrameToolBar();
        mainFrameToolBar.add(Main.getApplication().getActionCollection().get(QuitSoundAction.class));
    }

    private void playFile(File soundFile) {
        AudioInputStream in = null;
        try {
            in = AudioSystem.getAudioInputStream(soundFile);
            AudioFormat outFormat = this.getOutFormat(in.getFormat());
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, outFormat);
            this._sdl = (SourceDataLine)AudioSystem.getLine(info);
            this._sdl.open(outFormat);
            GUIUtils.processOnSwingEventThread(() -> this.addQuitSoundToolbarButton());
            this._sdl.start();
            this.stream(AudioSystem.getAudioInputStream(outFormat, in), this._sdl);
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.quit();
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private AudioFormat getOutFormat(AudioFormat inFormat) {
        int ch = inFormat.getChannels();
        float rate = inFormat.getSampleRate();
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, rate, 16, ch, ch * 2, rate, false);
    }

    private void stream(AudioInputStream in, SourceDataLine line) throws IOException {
        byte[] buffer = new byte[65536];
        int n = 0;
        while (n != -1) {
            line.write(buffer, 0, n);
            n = in.read(buffer, 0, buffer.length);
        }
    }

    private void beep() {
        try {
            byte[] buf = new byte[1];
            AudioFormat af = new AudioFormat(8000.0f, 8, 1, true, false);
            this._sdl = AudioSystem.getSourceDataLine(af);
            this._sdl.open(af);
            GUIUtils.processOnSwingEventThread(() -> this.addQuitSoundToolbarButton());
            this._sdl.start();
            int msecs = 1201;
            int hz = 800;
            double vol = 1.0;
            for (int i = 0; i < msecs * 8; ++i) {
                double angle = (double)((float)i / (8000.0f / (float)hz)) * 2.0 * Math.PI;
                buf[0] = (byte)(Math.sin(angle) * 127.0 * vol);
                this._sdl.write(buf, 0, 1);
            }
            this._sdl.stop();
            this._sdl.drain();
            this._sdl.close();
        }
        catch (LineUnavailableException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    public boolean quit() {
        GUIUtils.processOnSwingEventThread(() -> this.removeQuitSoundToolbarButton());
        SourceDataLine sdlBuf = this._sdl;
        if (null == sdlBuf) {
            return false;
        }
        sdlBuf.stop();
        return true;
    }

    public static void main(String[] args) throws InterruptedException {
        PLAYER.play(null);
        Thread.sleep(40000L);
    }
}

