/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTree;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.util.EnumerationIterator;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class ExpansionStateRestorer {
    public static List<TreePath> restoreExpansionState(ObjectTree objectTree, ObjectTreeNode startNode, TreePath[] previouslySelectedTreePaths, Set<String> expandedPathNames) {
        ArrayList<TreePath> treePathsToNewlySelect = new ArrayList<TreePath>();
        ExpansionStateRestorer._restoreExpansionState(objectTree, startNode, previouslySelectedTreePaths, treePathsToNewlySelect, expandedPathNames);
        return treePathsToNewlySelect;
    }

    private static void _restoreExpansionState(ObjectTree objectTree, ObjectTreeNode startNode, TreePath[] previouslySelectedTreePaths, List<TreePath> treePathsToNewlySelect, Set<String> expandedPathNames) {
        TreePath nodePath = new TreePath(startNode.getPath());
        if (ExpansionStateRestorer.wasPreviouslySelected(previouslySelectedTreePaths, startNode, nodePath)) {
            treePathsToNewlySelect.add(nodePath);
        }
        objectTree.expandPath(nodePath);
        Enumeration<TreeNode> childEnumeration = startNode.children();
        EnumerationIterator<TreeNode> it = new EnumerationIterator<TreeNode>(childEnumeration);
        while (it.hasNext()) {
            TreePath childPath;
            ObjectTreeNode child = (ObjectTreeNode)it.next();
            if (ExpansionStateRestorer.wasPreviouslySelected(previouslySelectedTreePaths, child, childPath = new TreePath(child.getPath()))) {
                treePathsToNewlySelect.add(childPath);
            }
            if (!expandedPathNames.contains(childPath.toString())) continue;
            ExpansionStateRestorer._restoreExpansionState(objectTree, child, previouslySelectedTreePaths, treePathsToNewlySelect, expandedPathNames);
        }
    }

    private static boolean wasPreviouslySelected(TreePath[] previouslySelectedTreePaths, ObjectTreeNode startNode, TreePath path) {
        for (TreePath previouslySelectedTreePath : previouslySelectedTreePaths) {
            if (!ExpansionStateRestorer.matches(path, previouslySelectedTreePath, ExpansionStateRestorer.isTableOrView(startNode))) continue;
            return true;
        }
        return false;
    }

    private static boolean isTableOrView(ObjectTreeNode startNode) {
        return startNode.getDatabaseObjectType() != DatabaseObjectType.TABLE || startNode.getDatabaseObjectType() != DatabaseObjectType.VIEW;
    }

    private static boolean matches(TreePath path1, TreePath path2, boolean tableOrView) {
        if (path1.getPath().length != path2.getPath().length) {
            return false;
        }
        for (int i = 0; i < path1.getPath().length; ++i) {
            String node2TillBracket;
            String node2Str;
            String node1Str = ExpansionStateRestorer.nodeObjToString(path1.getPath()[i]);
            if (StringUtilities.equalsRespectNullModuloEmptyAndWhiteSpace(node1Str, node2Str = ExpansionStateRestorer.nodeObjToString(path2.getPath()[i]))) continue;
            if (i < path1.getPath().length - 1) {
                return false;
            }
            if (!tableOrView) {
                return false;
            }
            if (-1 == node1Str.indexOf(40) || -1 == node2Str.indexOf(40)) {
                return false;
            }
            String node1TillBracket = node1Str.substring(0, node1Str.lastIndexOf(40));
            if (StringUtilities.equalsRespectNullModuloEmptyAndWhiteSpace(node1TillBracket, node2TillBracket = node2Str.substring(0, node2Str.lastIndexOf(40)))) continue;
            return false;
        }
        return true;
    }

    private static String nodeObjToString(Object nodeObj) {
        if (null == nodeObj) {
            return "<null>";
        }
        return nodeObj.toString();
    }
}

