/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.defaultentry.DefaultSQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.FindInObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.treefinder.ObjectTreeFinderGoToNextResultHandle;
import net.sourceforge.squirrel_sql.client.session.objecttreesearch.ObjectTreeSearch;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class FindInObjectTreeController {
    private static final String PREF_KEY_OBJECT_TREE_SEARCH_FILTER = "Squirrel.objTreeSearchFilter";
    private static final String PREF_KEY_OBJECT_TREE_SEARCH_APPEND_WILDCARD = "Squirrel.appendWildcard";
    private FindInObjectTreePanel _findInObjectTreePanel;
    private DefaultSQLEntryPanel _filterEditSQLEntryPanel;
    private IObjectTreeAPI _objectTreeAPI;
    private ObjectTreeFinderGoToNextResultHandle _goToNextResultHandle = new ObjectTreeFinderGoToNextResultHandle();

    public FindInObjectTreeController(IObjectTreeAPI objectTreeAPI) {
        this._objectTreeAPI = objectTreeAPI;
        this._filterEditSQLEntryPanel = new DefaultSQLEntryPanel(objectTreeAPI.getSession());
        this._filterEditSQLEntryPanel.setMarkCurrentSQLActive(false);
        this._findInObjectTreePanel = new FindInObjectTreePanel(this._filterEditSQLEntryPanel.getTextComponent(), Main.getApplication().getResources());
        AbstractAction findAction = new AbstractAction("ObjectTree.Find"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindInObjectTreeController.this.onEnter();
            }
        };
        AbstractAction transferFocusAction = new AbstractAction("ObjectTree.TransferFocus"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindInObjectTreeController.this._filterEditSQLEntryPanel.getTextComponent().transferFocus();
            }
        };
        this._filterEditSQLEntryPanel.getTextComponent().registerKeyboardAction(findAction, KeyStroke.getKeyStroke(10, 0, false), 0);
        this._filterEditSQLEntryPanel.getTextComponent().registerKeyboardAction(transferFocusAction, KeyStroke.getKeyStroke(9, 64, false), 0);
        boolean filter = Props.getBoolean(PREF_KEY_OBJECT_TREE_SEARCH_FILTER, false);
        this._findInObjectTreePanel.btnApplyAsFilter.setSelected(filter);
        boolean appendWildcard = Props.getBoolean(PREF_KEY_OBJECT_TREE_SEARCH_APPEND_WILDCARD, true);
        this._findInObjectTreePanel.setAppendWildcard(appendWildcard);
        this._findInObjectTreePanel.btnFind.addActionListener(e -> this.onFind(false));
        this._findInObjectTreePanel.btnApplyAsFilter.addActionListener(e -> this.onFind(false == this._findInObjectTreePanel.btnApplyAsFilter.isSelected()));
    }

    private void onFind(boolean unfilterTreeFirst) {
        String searchString;
        if (unfilterTreeFirst) {
            this._objectTreeAPI.getSession().getProperties().setObjectFilterInclude(null);
            this._objectTreeAPI.refreshSelectedNodes();
        }
        if (StringUtilities.isEmpty(searchString = this.getSearchString(), true)) {
            return;
        }
        if (this._findInObjectTreePanel.btnApplyAsFilter.isSelected()) {
            if (this._goToNextResultHandle.setCurrentSearchState(searchString, true)) {
                this._objectTreeAPI.getSession().getProperties().setObjectFilterInclude(searchString);
                this._objectTreeAPI.refreshSelectedNodes();
            }
            SwingUtilities.invokeLater(() -> new ObjectTreeSearch().viewObjectInObjectTree(searchString, this._objectTreeAPI, this._goToNextResultHandle));
        } else {
            this._goToNextResultHandle.setCurrentSearchState(searchString, false);
            new ObjectTreeSearch().viewObjectInObjectTree(searchString, this._objectTreeAPI, this._goToNextResultHandle);
        }
    }

    private String getSearchString() {
        String ret = this._filterEditSQLEntryPanel.getText();
        if (StringUtilities.isEmpty(ret, true)) {
            return null;
        }
        if (this._findInObjectTreePanel.isAppendWildCard() && -1 == ret.indexOf(37)) {
            return ret + "%";
        }
        return ret;
    }

    private void onEnter() {
        this._findInObjectTreePanel.btnFind.doClick();
    }

    public JPanel getFindInObjectTreePanel() {
        return this._findInObjectTreePanel;
    }

    public ISQLEntryPanel getFindEntryPanel() {
        return this._filterEditSQLEntryPanel;
    }

    public void dispose() {
        Props.putBoolean(PREF_KEY_OBJECT_TREE_SEARCH_FILTER, this._findInObjectTreePanel.btnApplyAsFilter.isSelected());
        Props.putBoolean(PREF_KEY_OBJECT_TREE_SEARCH_APPEND_WILDCARD, this._findInObjectTreePanel.isAppendWildCard());
    }
}

