/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.buttonchooser.ButtonChooser;
import net.sourceforge.squirrel_sql.fw.gui.buttonchooser.ButtonChooserOrientation;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class FindInObjectTreePanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FindInObjectTreePanel.class);
    JButton btnFind;
    JToggleButton btnApplyAsFilter;
    ButtonChooser chooserAppendWildcard;
    private JButton btnAppendWildcard;
    private JButton btnDontAppendWildcard;

    public FindInObjectTreePanel(JTextComponent textComponent, SquirrelResources resources) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 2, 2, 0), 0, 0);
        this.add((Component)textComponent, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 2, 0), 0, 0);
        this.btnFind = new JButton(resources.getIcon("find"));
        this.btnFind.setBorder(BorderFactory.createEtchedBorder());
        this.btnFind.setToolTipText(s_stringMgr.getString("FindInObjectTreePanel.findNew"));
        this.add((Component)this.btnFind, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 2, 0), 0, 0);
        this.btnApplyAsFilter = new JToggleButton(resources.getIcon("filter"));
        this.btnApplyAsFilter.setBorder(BorderFactory.createEtchedBorder());
        this.btnApplyAsFilter.setToolTipText(s_stringMgr.getString("FindInObjectTreePanel.applyAsFilter"));
        this.add((Component)this.btnApplyAsFilter, gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 1, 2, 0), 0, 0);
        this.chooserAppendWildcard = this.createWildcardChooser(resources);
        this.chooserAppendWildcard.setPreferredHeight(this.btnFind.getPreferredSize().height);
        this.add((Component)this.chooserAppendWildcard.getComponent(), gbc);
        GUIUtils.setPreferredHeight(textComponent, this.btnFind.getPreferredSize().height);
        textComponent.setBorder(BorderFactory.createEtchedBorder());
    }

    private ButtonChooser createWildcardChooser(SquirrelResources resources) {
        ButtonChooser ret = new ButtonChooser(false, ButtonChooserOrientation.LEFT);
        this.btnAppendWildcard = new JButton(s_stringMgr.getString("FindInObjectTreePanel.appendWildcard"), resources.getIcon("percent"));
        this.btnAppendWildcard.setToolTipText(s_stringMgr.getString("FindInObjectTreePanel.appendWildcard"));
        this.btnAppendWildcard.setBorder(BorderFactory.createEmptyBorder());
        ret.addUnclickableButton(this.btnAppendWildcard);
        this.btnDontAppendWildcard = new JButton(s_stringMgr.getString("FindInObjectTreePanel.dontAppendWildcard"), resources.getIcon("percent_negated"));
        this.btnDontAppendWildcard.setToolTipText(s_stringMgr.getString("FindInObjectTreePanel.dontAppendWildcard"));
        this.btnDontAppendWildcard.setBorder(BorderFactory.createEmptyBorder());
        ret.addUnclickableButton(this.btnDontAppendWildcard);
        return ret;
    }

    boolean isAppendWildCard() {
        return this.chooserAppendWildcard.getSelectedButton() == this.btnAppendWildcard;
    }

    public void setAppendWildcard(boolean appendWildcard) {
        if (appendWildcard) {
            this.chooserAppendWildcard.setSelectedButton(this.btnAppendWildcard);
        } else {
            this.chooserAppendWildcard.setSelectedButton(this.btnDontAppendWildcard);
        }
    }
}

