/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.session.SessionColoringUtil;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.CopyQualifiedObjectNameAction;
import net.sourceforge.squirrel_sql.client.session.action.CopySimpleObjectNameAction;
import net.sourceforge.squirrel_sql.client.session.action.DeleteSelectedTablesAction;
import net.sourceforge.squirrel_sql.client.session.action.EditWhereColsAction;
import net.sourceforge.squirrel_sql.client.session.action.FilterObjectsAction;
import net.sourceforge.squirrel_sql.client.session.action.FindColumnsInObjectTreeNodesAction;
import net.sourceforge.squirrel_sql.client.session.action.RefreshObjectTreeItemAction;
import net.sourceforge.squirrel_sql.client.session.action.RefreshSchemaInfoAction;
import net.sourceforge.squirrel_sql.client.session.action.SQLFilterAction;
import net.sourceforge.squirrel_sql.client.session.action.SetDefaultCatalogAction;
import net.sourceforge.squirrel_sql.client.session.action.ShowTableReferencesAction;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.action.ImportTableDataAction;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.DBDiffObjectTreeMenuFactory;
import net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection.CopyRestoreSelectionMenuFactory;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.SQLScriptMenuFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ExpansionStateRestorer;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.IObjectTreeListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeCellRenderer;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeListenerEvent;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeMenuEntry;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeModel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.TreeLoader;
import net.sourceforge.squirrel_sql.client.session.menuattic.AtticHandler;
import net.sourceforge.squirrel_sql.client.session.menuattic.MenuOrigin;
import net.sourceforge.squirrel_sql.fw.gui.CursorChanger;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ObjectTree
extends JTree {
    private static final ILogger s_log = LoggerController.createLogger(ObjectTree.class);
    private final ISession _session;
    private final Map<DatabaseObjectType, List<ObjectTreeMenuEntry>> _dbObjType_menuEntries = new HashMap<DatabaseObjectType, List<ObjectTreeMenuEntry>>();
    private final List<ObjectTreeMenuEntry> _globalPopupMenuEntries = new ArrayList<ObjectTreeMenuEntry>();
    private Set<String> _expandedPathNames = new HashSet<String>();
    private EventListenerList _listenerList = new EventListenerList();

    ObjectTree(ISession session) {
        super(new ObjectTreeModel(session));
        try {
            this.setRowHeight(this.getFontMetrics(this.getFont()).getHeight());
            this._session = session;
            this.addTreeExpansionListener(new NodeExpansionListener());
            this.addTreeSelectionListener(e -> this.onTreeSelectionChanged(e));
            this.setShowsRootHandles(true);
            ActionCollection actions = session.getApplication().getActionCollection();
            this.addToPopup(actions.get(RefreshSchemaInfoAction.class));
            this.addToPopup(actions.get(RefreshObjectTreeItemAction.class));
            this.addToPopup(actions.get(FindColumnsInObjectTreeNodesAction.class));
            this.addToPopup(DatabaseObjectType.TABLE, actions.get(EditWhereColsAction.class));
            this.addToPopup(DatabaseObjectType.TABLE, actions.get(SQLFilterAction.class));
            this.addToPopup(DatabaseObjectType.VIEW, actions.get(SQLFilterAction.class));
            this.addToPopup(DatabaseObjectType.TABLE, actions.get(DeleteSelectedTablesAction.class));
            this.addToPopup(DatabaseObjectType.TABLE, actions.get(ShowTableReferencesAction.class));
            this.addToPopup(DatabaseObjectType.SESSION, actions.get(FilterObjectsAction.class));
            if (this._session.getSQLConnection().getSQLMetaData().supportsCatalogs()) {
                this.addToPopup(DatabaseObjectType.CATALOG, actions.get(SetDefaultCatalogAction.class));
            }
            this.addToPopup(actions.get(CopySimpleObjectNameAction.class));
            this.addToPopup(actions.get(CopyQualifiedObjectNameAction.class));
            this.addToPopup(CopyRestoreSelectionMenuFactory.getObjectTreeMenu());
            this.addToPopup(DatabaseObjectType.TABLE, SQLScriptMenuFactory.getObjectTreeMenu(DatabaseObjectType.TABLE));
            this.addToPopup(DatabaseObjectType.VIEW, SQLScriptMenuFactory.getObjectTreeMenu(DatabaseObjectType.VIEW));
            this.addToPopup(DatabaseObjectType.TABLE, SQLScriptMenuFactory.getExportAction());
            this.addToPopup(DatabaseObjectType.VIEW, SQLScriptMenuFactory.getExportAction());
            this.addToPopup(DatabaseObjectType.TABLE, actions.get(ImportTableDataAction.class));
            this.addToPopup(DatabaseObjectType.TABLE_TYPE_DBO, actions.get(ImportTableDataAction.class));
            this.addToPopup(DatabaseObjectType.SESSION, actions.get(ImportTableDataAction.class));
            this.addToPopup(DatabaseObjectType.SCHEMA, actions.get(ImportTableDataAction.class));
            this.addToPopup(DatabaseObjectType.CATALOG, actions.get(ImportTableDataAction.class));
            this.addToPopup(DatabaseObjectType.TABLE, DBDiffObjectTreeMenuFactory.createMenu());
            this.addMouseListener(new ObjectTreeMouseListener());
            this.setCellRenderer(new ObjectTreeCellRenderer(this.getObjectTreeModel(), this._session));
            SwingUtilities.invokeLater(() -> {
                this.refresh(false);
                this.setSelectionPath(this.getPathForRow(0));
                SessionColoringUtil.colorTree(session, this);
            });
        }
        catch (SQLException e2) {
            throw Utilities.wrapRuntime(e2);
        }
    }

    private void onTreeSelectionChanged(TreeSelectionEvent e) {
        if (null != e.getNewLeadSelectionPath()) {
            this.scrollPathToVisible(e.getNewLeadSelectionPath());
        }
    }

    public ObjectTreeModel getObjectTreeModel() {
        return (ObjectTreeModel)this.getModel();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        String tip = null;
        TreePath path = this.getPathForLocation(evt.getX(), evt.getY());
        tip = path != null ? path.getLastPathComponent().toString() : this.getToolTipText();
        return tip;
    }

    public void refresh(final boolean reloadSchemaInfo) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (reloadSchemaInfo) {
                    ObjectTree.this._session.getSchemaInfo().reloadAll();
                }
                GUIUtils.processOnSwingEventThread(() -> ObjectTree.this.refreshTree());
            }
        };
        if (reloadSchemaInfo) {
            this._session.getApplication().getThreadPool().addTask(task);
        } else {
            task.run();
        }
    }

    private void refreshTree() {
        TreePath[] previouslySelectedTreePaths = this.getSelectionPaths();
        ObjectTreeNode root = this.getObjectTreeModel().getRootObjectTreeNode();
        root.removeAllChildren();
        this.fireObjectTreeCleared();
        this.expandTree(root, previouslySelectedTreePaths, false);
        this.fireObjectTreeRefreshed();
    }

    public void refreshSelectedNodes() {
        TreePath[] selectedPaths = this.getSelectionPaths();
        ObjectTreeNode[] nodesToRefresh = this.getSelectedNodes();
        this.clearSelection();
        DefaultMutableTreeNode parent = null;
        if (0 < nodesToRefresh.length) {
            parent = (DefaultMutableTreeNode)nodesToRefresh[0].getParent();
        }
        if (parent != null) {
            parent.removeAllChildren();
            this.expandTree((ObjectTreeNode)parent, selectedPaths, true);
        } else if (0 < nodesToRefresh.length) {
            nodesToRefresh[0].removeAllChildren();
            this.expandTree(nodesToRefresh[0], selectedPaths, true);
        }
    }

    public void addObjectTreeListener(IObjectTreeListener lis) {
        this._listenerList.add(IObjectTreeListener.class, lis);
    }

    void removeObjectTreeListener(IObjectTreeListener lis) {
        this._listenerList.remove(IObjectTreeListener.class, lis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandTree(ObjectTreeNode startNode, TreePath[] previouslySelectedTreePaths, boolean refreshSchemaInfo) {
        CursorChanger cursorChg = new CursorChanger(this);
        cursorChg.show();
        try {
            if (refreshSchemaInfo) {
                this._session.getSchemaInfo().reload(startNode.getDatabaseObjectInfo());
            }
            this.expandNode(startNode);
            if (previouslySelectedTreePaths != null) {
                List<TreePath> newlySelectedTreepaths = ExpansionStateRestorer.restoreExpansionState(this, startNode, previouslySelectedTreePaths, this._expandedPathNames);
                this.setSelectionPaths(newlySelectedTreepaths.toArray(new TreePath[0]));
            }
        }
        finally {
            cursorChg.restore();
        }
    }

    public void expandNode(ObjectTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("ObjectTreeNode == null");
        }
        if (node.getChildCount() == 0 && !node.hasNoChildrenFoundWithExpander()) {
            DatabaseObjectType dboType = node.getDatabaseObjectType();
            INodeExpander[] stdExpanders = this.getObjectTreeModel().getExpanders(dboType);
            INodeExpander[] extraExpanders = node.getExpanders();
            if (stdExpanders.length > 0 || extraExpanders.length > 0) {
                INodeExpander[] expanders = null;
                if (stdExpanders.length > 0 && extraExpanders.length == 0) {
                    expanders = stdExpanders;
                } else if (stdExpanders.length == 0 && extraExpanders.length > 0) {
                    expanders = extraExpanders;
                } else {
                    expanders = new INodeExpander[stdExpanders.length + extraExpanders.length];
                    System.arraycopy(stdExpanders, 0, expanders, 0, stdExpanders.length);
                    System.arraycopy(extraExpanders, 0, expanders, stdExpanders.length, extraExpanders.length);
                }
                new TreeLoader(this._session, this, this.getObjectTreeModel(), node, expanders).execute();
            }
        }
    }

    void addToPopup(DatabaseObjectType dboType, Action action) {
        if (dboType == null) {
            throw new IllegalArgumentException("Null DatabaseObjectType passed");
        }
        if (action == null) {
            throw new IllegalArgumentException("Null Action passed");
        }
        List objectTreeMenuEntries = this._dbObjType_menuEntries.computeIfAbsent(dboType, k -> new ArrayList());
        objectTreeMenuEntries.add(new ObjectTreeMenuEntry(action));
    }

    void addToPopup(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Null Action passed");
        }
        this._globalPopupMenuEntries.add(new ObjectTreeMenuEntry(action));
    }

    public void addToPopup(DatabaseObjectType dboType, JMenu menu) {
        if (dboType == null) {
            throw new IllegalArgumentException("DatabaseObjectType == null");
        }
        if (menu == null) {
            throw new IllegalArgumentException("JMenu == null");
        }
        List objectTreeMenuEntries = this._dbObjType_menuEntries.computeIfAbsent(dboType, k -> new ArrayList());
        objectTreeMenuEntries.add(new ObjectTreeMenuEntry(menu));
    }

    public void addToPopup(JMenu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("JMenu == null");
        }
        this._globalPopupMenuEntries.add(new ObjectTreeMenuEntry(menu));
    }

    private JPopupMenu getPopup(DatabaseObjectType dboType) {
        if (dboType == null) {
            throw new IllegalArgumentException("Null DatabaseObjectType passed");
        }
        List<ObjectTreeMenuEntry> dboTypeMenuEntries = this._dbObjType_menuEntries.get(dboType);
        if (dboTypeMenuEntries != null) {
            return this.toPopupMenu(this._globalPopupMenuEntries, dboTypeMenuEntries);
        }
        return this.toPopupMenu(this._globalPopupMenuEntries);
    }

    private JPopupMenu toPopupMenu(List<ObjectTreeMenuEntry> ... objectTreeMenuEntryLists) {
        JPopupMenu ret = new JPopupMenu();
        for (List<ObjectTreeMenuEntry> objectTreeMenuEntryList : objectTreeMenuEntryLists) {
            for (ObjectTreeMenuEntry globalPopupMenuEntry : objectTreeMenuEntryList) {
                globalPopupMenuEntry.addToPopup(ret);
            }
        }
        return ret;
    }

    ObjectTreeNode[] getSelectedNodes() {
        TreePath[] paths = this.getSelectionPaths();
        ArrayList<ObjectTreeNode> list = new ArrayList<ObjectTreeNode>();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                Object obj = paths[i].getLastPathComponent();
                if (!(obj instanceof ObjectTreeNode)) continue;
                list.add((ObjectTreeNode)obj);
            }
        }
        ObjectTreeNode[] ar = list.toArray(new ObjectTreeNode[list.size()]);
        Arrays.sort(ar, new NodeComparator());
        return ar;
    }

    IDatabaseObjectInfo[] getSelectedDatabaseObjects() {
        ObjectTreeNode[] nodes = this.getSelectedNodes();
        IDatabaseObjectInfo[] dbObjects = new IDatabaseObjectInfo[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            dbObjects[i] = nodes[i].getDatabaseObjectInfo();
        }
        return dbObjects;
    }

    List<ITableInfo> getSelectedTables() {
        ObjectTreeNode[] nodes = this.getSelectedNodes();
        ArrayList<ITableInfo> result = new ArrayList<ITableInfo>();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i].getDatabaseObjectType() != DatabaseObjectType.TABLE) continue;
            result.add((ITableInfo)nodes[i].getDatabaseObjectInfo());
        }
        return result;
    }

    private void showPopup(int x, int y) {
        ObjectTreeNode[] selObj = this.getSelectedNodes();
        if (selObj.length > 0) {
            boolean sameType = true;
            DatabaseObjectType dboType = selObj[0].getDatabaseObjectType();
            for (int i = 1; i < selObj.length; ++i) {
                if (selObj[i].getDatabaseObjectType() == dboType) continue;
                sameType = false;
                break;
            }
            JPopupMenu ret = sameType ? this.getPopup(dboType) : this.toPopupMenu(this._globalPopupMenuEntries);
            AtticHandler.initAtticForMenu(ret, MenuOrigin.OBJECT_TREE);
            ret.show(this, x, y);
        }
    }

    private void fireObjectTreeCleared() {
        Object[] listeners = this._listenerList.getListenerList();
        ObjectTreeListenerEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IObjectTreeListener.class) continue;
            if (evt == null) {
                evt = new ObjectTreeListenerEvent(this);
            }
            ((IObjectTreeListener)listeners[i + 1]).objectTreeCleared(evt);
        }
    }

    private void fireObjectTreeRefreshed() {
        Object[] listeners = this._listenerList.getListenerList();
        ObjectTreeListenerEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IObjectTreeListener.class) continue;
            if (evt == null) {
                evt = new ObjectTreeListenerEvent(this);
            }
            ((IObjectTreeListener)listeners[i + 1]).objectTreeRefreshed(evt);
        }
    }

    public ISession getSession() {
        return this._session;
    }

    public void dispose() {
        this._dbObjType_menuEntries.clear();
        this._globalPopupMenuEntries.clear();
    }

    private static class NodeComparator
    implements Comparator<ObjectTreeNode>,
    Serializable {
        private NodeComparator() {
        }

        @Override
        public int compare(ObjectTreeNode obj1, ObjectTreeNode obj2) {
            return obj1.toString().compareToIgnoreCase(obj2.toString());
        }
    }

    private final class NodeExpansionListener
    implements TreeExpansionListener {
        private NodeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent evt) {
            TreePath path = evt.getPath();
            Object parentObj = path.getLastPathComponent();
            if (parentObj instanceof ObjectTreeNode) {
                ObjectTree.this.expandTree((ObjectTreeNode)parentObj, null, false);
                ObjectTree.this._expandedPathNames.add(path.toString());
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent evt) {
            ObjectTree.this._expandedPathNames.remove(evt.getPath().toString());
        }
    }

    private class ObjectTreeMouseListener
    extends MouseAdapter {
        private ObjectTreeMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            this.checkSelectAndPopUp(evt);
        }

        private void checkSelectAndPopUp(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                if (ObjectTree.this._session.getApplication().getSquirrelPreferences().getSelectOnRightMouseClick()) {
                    TreePath path = ObjectTree.this.getPathForLocation(evt.getX(), evt.getY());
                    boolean alreadySelected = false;
                    TreePath[] selectedPaths = ObjectTree.this.getSelectionPaths();
                    if (selectedPaths != null) {
                        for (TreePath selectedPath : selectedPaths) {
                            if (path == null || !path.equals(selectedPath)) continue;
                            alreadySelected = true;
                            break;
                        }
                    }
                    if (!alreadySelected) {
                        ObjectTree.this.setSelectionPath(path);
                    }
                }
                ObjectTree.this.showPopup(evt.getX(), evt.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.checkSelectAndPopUp(evt);
        }
    }
}

