/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.DatabaseObjectTypeComparator;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;

public class ObjectTreeExpanders {
    private Map<IIdentifier, List<INodeExpander>> _expanders = new HashMap<IIdentifier, List<INodeExpander>>();
    private final Set<DatabaseObjectType> _objectTypes = new TreeSet<DatabaseObjectType>(new DatabaseObjectTypeComparator());

    public List<INodeExpander> getByKey(IIdentifier key) {
        List<INodeExpander> list = this._expanders.get(key);
        if (list == null) {
            list = new ArrayList<INodeExpander>();
            this._expanders.put(key, list);
        }
        return list;
    }

    public INodeExpander[] getExpanders(DatabaseObjectType dboType) {
        if (dboType == null) {
            throw new IllegalArgumentException("Null DatabaseObjectType passed");
        }
        List<INodeExpander> list = this.getExpandersList(dboType);
        return list.toArray(new INodeExpander[0]);
    }

    private List<INodeExpander> getExpandersList(DatabaseObjectType dboType) {
        if (dboType == null) {
            throw new IllegalArgumentException("Null DatabaseObjectType passed");
        }
        IIdentifier key = dboType.getIdentifier();
        List<INodeExpander> list = this.getByKey(key);
        return list;
    }

    public void addExpander(DatabaseObjectType dboType, INodeExpander expander) {
        if (dboType == null) {
            throw new IllegalArgumentException("Null DatabaseObjectType passed");
        }
        if (expander == null) {
            throw new IllegalArgumentException("Null INodeExpander passed");
        }
        this.getExpandersList(dboType).add(expander);
        this.addKnownDatabaseObjectType(dboType);
    }

    void addKnownDatabaseObjectType(DatabaseObjectType dboType) {
        this._objectTypes.add(dboType);
    }

    public DatabaseObjectType[] getDatabaseObjectTypes() {
        DatabaseObjectType[] ar = new DatabaseObjectType[this._objectTypes.size()];
        return this._objectTypes.toArray(ar);
    }
}

