/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree;

import java.util.Iterator;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import net.sourceforge.squirrel_sql.client.plugin.IPluginManager;
import net.sourceforge.squirrel_sql.client.plugin.ISessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.SessionPluginInfo;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeExpanders;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeRootNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.DatabaseExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ProcedureTypeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TableTypeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.UDTTypeExpander;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;

public class ObjectTreeModel
extends DefaultTreeModel {
    private ObjectTreeExpanders _expanders = new ObjectTreeExpanders();

    public ObjectTreeModel(ISession session) {
        super(ObjectTreeModel.createRootNode(session), true);
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        DatabaseExpander expander = new DatabaseExpander(session);
        SwingUtilities.invokeLater(() -> this.initExpanders(expander, session));
    }

    private void initExpanders(INodeExpander expander, ISession session) {
        this.addExpander(DatabaseObjectType.CATALOG, expander);
        this.addExpander(DatabaseObjectType.SCHEMA, expander);
        boolean foundTableExp = false;
        boolean foundProcExp = false;
        boolean foundUDTExp = false;
        boolean foundDatabaseExp = false;
        IPluginManager pmgr = session.getApplication().getPluginManager();
        Iterator<SessionPluginInfo> pluginItr = pmgr.getSessionPluginIterator();
        while (pluginItr.hasNext()) {
            INodeExpander databaseExp;
            INodeExpander udtExp;
            INodeExpander procExp;
            ISessionPlugin p = pluginItr.next().getSessionPlugin();
            INodeExpander tableExp = p.getDefaultNodeExpander(session, DatabaseObjectType.TABLE_TYPE_DBO);
            if (tableExp != null) {
                foundTableExp = true;
                this.addExpander(DatabaseObjectType.TABLE_TYPE_DBO, tableExp);
            }
            if ((procExp = p.getDefaultNodeExpander(session, DatabaseObjectType.PROC_TYPE_DBO)) != null) {
                foundProcExp = true;
                this.addExpander(DatabaseObjectType.PROC_TYPE_DBO, procExp);
            }
            if ((udtExp = p.getDefaultNodeExpander(session, DatabaseObjectType.UDT_TYPE_DBO)) != null) {
                foundUDTExp = true;
                this.addExpander(DatabaseObjectType.UDT_TYPE_DBO, udtExp);
            }
            if ((databaseExp = p.getDefaultNodeExpander(session, DatabaseObjectType.DATABASE_TYPE_DBO)) == null) continue;
            foundDatabaseExp = true;
            this.addExpander(DatabaseObjectType.SESSION, databaseExp);
        }
        if (!foundTableExp) {
            this.addExpander(DatabaseObjectType.TABLE_TYPE_DBO, new TableTypeExpander());
        }
        if (!foundProcExp) {
            this.addExpander(DatabaseObjectType.PROC_TYPE_DBO, new ProcedureTypeExpander());
        }
        if (!foundUDTExp) {
            this.addExpander(DatabaseObjectType.UDT_TYPE_DBO, new UDTTypeExpander());
        }
        if (!foundDatabaseExp) {
            this.addExpander(DatabaseObjectType.SESSION, expander);
        }
        this.reload();
    }

    public void addExpander(DatabaseObjectType dboType, INodeExpander expander) {
        if (dboType == null) {
            throw new IllegalArgumentException("Null DatabaseObjectType passed");
        }
        if (expander == null) {
            throw new IllegalArgumentException("Null INodeExpander passed");
        }
        this._expanders.addExpander(dboType, expander);
    }

    ObjectTreeNode getRootObjectTreeNode() {
        return (ObjectTreeNode)this.getRoot();
    }

    private static ObjectTreeNode createRootNode(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        return new ObjectTreeRootNode(session);
    }

    public boolean isRootNode(Object node) {
        return node instanceof ObjectTreeRootNode;
    }

    public INodeExpander[] getExpanders(DatabaseObjectType dboType) {
        return this._expanders.getExpanders(dboType);
    }

    public void addKnownDatabaseObjectType(DatabaseObjectType dboType) {
        this._expanders.addKnownDatabaseObjectType(dboType);
    }

    public DatabaseObjectType[] getDatabaseObjectTypes() {
        return this._expanders.getDatabaseObjectTypes();
    }
}

