/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;

public class ObjectTreeNode
extends DefaultMutableTreeNode {
    private final IApplication _app;
    private final IIdentifier _sessionId;
    private final IDatabaseObjectInfo _dboInfo;
    private boolean _allowsChildren = true;
    private final List<INodeExpander> _expanders = new ArrayList<INodeExpander>();
    private boolean noChildrenFoundWithExpander = false;

    public ObjectTreeNode(ISession session, IDatabaseObjectInfo dboInfo) {
        super(ObjectTreeNode.getNodeTitle(dboInfo));
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        if (dboInfo == null) {
            throw new IllegalArgumentException("IDatabaseObjectInfo == null");
        }
        this._app = session.getApplication();
        this._sessionId = session.getIdentifier();
        this._dboInfo = dboInfo;
    }

    @Override
    public void add(MutableTreeNode newChild) {
        super.add(newChild);
        newChild.setParent(this);
    }

    public ISession getSession() {
        return this._app.getSessionManager().getSession(this._sessionId);
    }

    public IDatabaseObjectInfo getDatabaseObjectInfo() {
        return this._dboInfo;
    }

    public DatabaseObjectType getDatabaseObjectType() {
        return this._dboInfo.getDatabaseObjectType();
    }

    @Override
    public boolean getAllowsChildren() {
        return this._allowsChildren;
    }

    @Override
    public boolean isLeaf() {
        return !this._allowsChildren;
    }

    public INodeExpander[] getExpanders() {
        return this._expanders.toArray(new INodeExpander[this._expanders.size()]);
    }

    public void addExpander(INodeExpander value) {
        if (value == null) {
            throw new IllegalArgumentException("INodeExpander == null");
        }
        this._expanders.add(value);
    }

    @Override
    public void setAllowsChildren(boolean value) {
        super.setAllowsChildren(value);
        this._allowsChildren = value;
    }

    private static String getNodeTitle(IDatabaseObjectInfo dbinfo) {
        if (dbinfo == null) {
            throw new IllegalArgumentException("IDatabaseObjectInfo == null");
        }
        return dbinfo.toString();
    }

    public Icon getIcon() {
        return this._dboInfo.getDatabaseObjectType().getIcon();
    }

    public boolean hasNoChildrenFoundWithExpander() {
        return this.noChildrenFoundWithExpander;
    }

    public void setNoChildrenFoundWithExpander(boolean noChildrenFoundWithExpander) {
        this.noChildrenFoundWithExpander = noChildrenFoundWithExpander;
    }
}

