/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree;

import java.sql.SQLException;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTree;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeModel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class TreeLoader {
    private static final ILogger s_log = LoggerController.createLogger(TreeLoader.class);
    private ObjectTree _objectTree;
    private ObjectTreeNode _parentNode;
    private INodeExpander[] _expanders;
    private ObjectTreeModel _model;
    private ISession _session;

    TreeLoader(ISession session, ObjectTree objectTree, ObjectTreeModel model, ObjectTreeNode parentNode, INodeExpander[] expanders) {
        this._session = session;
        this._objectTree = objectTree;
        this._model = model;
        this._parentNode = parentNode;
        this._expanders = expanders;
    }

    void execute() {
        try {
            this.loadChildren();
        }
        catch (Throwable ex) {
            String msg = "Error: " + this._parentNode.toString();
            s_log.error(msg, ex);
            this._session.showErrorMessage(msg + ": " + ex.toString());
        }
        finally {
            this._model.nodeStructureChanged(this._parentNode);
        }
    }

    private void loadChildren() throws SQLException {
        boolean noChildrenFound = true;
        for (int i = 0; i < this._expanders.length; ++i) {
            boolean nodeTypeAllowsChildren = false;
            DatabaseObjectType lastDboType = null;
            List<ObjectTreeNode> list = this._expanders[i].createChildren(this._session, this._parentNode);
            if (!list.isEmpty()) {
                noChildrenFound = false;
            }
            for (ObjectTreeNode nextObj : list) {
                if (!(nextObj instanceof ObjectTreeNode)) continue;
                ObjectTreeNode childNode = nextObj;
                if (childNode.getExpanders().length > 0) {
                    childNode.setAllowsChildren(true);
                } else {
                    DatabaseObjectType childNodeDboType = childNode.getDatabaseObjectType();
                    if (childNodeDboType != lastDboType) {
                        this._objectTree.getObjectTreeModel().addKnownDatabaseObjectType(childNodeDboType);
                        lastDboType = childNodeDboType;
                        nodeTypeAllowsChildren = this._model.getExpanders(childNodeDboType).length > 0;
                    }
                    childNode.setAllowsChildren(nodeTypeAllowsChildren);
                }
                this._parentNode.add(childNode);
            }
        }
        this._parentNode.setNoChildrenFoundWithExpander(noChildrenFound);
    }
}

