/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.schemainfo.CatalogFilterMatcher;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaFilterMatcher;
import net.sourceforge.squirrel_sql.client.session.schemainfo.TableTypeFilterMatcher;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DatabaseExpander
implements INodeExpander {
    private static ILogger s_log = LoggerController.createLogger(DatabaseExpander.class);
    private String[] _tableTypes = new String[0];

    public DatabaseExpander(ISession session) {
        try {
            this._tableTypes = session.getSQLConnection().getSQLMetaData().getTableTypes();
        }
        catch (SQLException e) {
            s_log.warn("DBMS doesn't support 'getTableTypes()", e);
        }
    }

    @Override
    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) throws SQLException {
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        ISQLConnection conn = session.getSQLConnection();
        SQLDatabaseMetaData md = conn.getSQLMetaData();
        boolean supportsCatalogs = false;
        try {
            supportsCatalogs = md.supportsCatalogs();
        }
        catch (SQLException ex) {
            s_log.debug("DBMS doesn't support 'supportsCatalogs()", ex);
        }
        boolean supportsSchemas = false;
        try {
            supportsSchemas = md.supportsSchemas();
        }
        catch (SQLException ex) {
            s_log.debug("DBMS doesn't support 'supportsSchemas()", ex);
        }
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        if (parentDbinfo.getDatabaseObjectType() == DatabaseObjectType.SESSION) {
            List<Object> addedChildren = new ArrayList();
            if (supportsCatalogs) {
                addedChildren = this.createCatalogNodes(session, md);
                childNodes.addAll(addedChildren);
            }
            if (addedChildren.size() == 0 && supportsSchemas) {
                addedChildren = this.createSchemaNodes(session, md, null);
                childNodes.addAll(addedChildren);
            }
            if (addedChildren.size() == 0) {
                childNodes.addAll(this.createObjectTypeNodes(session, null, null));
            }
        } else if (parentDbinfo.getDatabaseObjectType() == DatabaseObjectType.CATALOG) {
            String catalogName = parentDbinfo.getSimpleName();
            List<Object> addedChildren = new ArrayList();
            if (supportsSchemas) {
                addedChildren = this.createSchemaNodes(session, md, catalogName);
                childNodes.addAll(addedChildren);
            }
            if (addedChildren.size() == 0) {
                childNodes.addAll(this.createObjectTypeNodes(session, catalogName, null));
            }
        } else if (parentDbinfo.getDatabaseObjectType() == DatabaseObjectType.SCHEMA) {
            String catalogName = parentDbinfo.getCatalogName();
            String schemaName = parentDbinfo.getSimpleName();
            childNodes.addAll(this.createObjectTypeNodes(session, catalogName, schemaName));
        }
        return childNodes;
    }

    private List<ObjectTreeNode> createCatalogNodes(ISession session, SQLDatabaseMetaData md) throws SQLException {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        if (session.getProperties().getLoadSchemasCatalogs()) {
            String connectionsCurrentCatalog = null;
            try {
                connectionsCurrentCatalog = session.getSQLConnection().getCatalog();
            }
            catch (Exception e) {
                s_log.error("Failed to get connections current catalog", e);
            }
            String[] catalogs = session.getProperties().getLoadConnectionsCurrentCatalogOnly() && false == StringUtilities.isEmpty(connectionsCurrentCatalog, true) ? new String[]{connectionsCurrentCatalog} : md.getCatalogs();
            CatalogFilterMatcher filterMatcher = new CatalogFilterMatcher(session.getProperties());
            for (int i = 0; i < catalogs.length; ++i) {
                DatabaseObjectInfo dbo = new DatabaseObjectInfo(null, null, catalogs[i], DatabaseObjectType.CATALOG, md);
                if (!filterMatcher.matches(dbo.getSimpleName())) continue;
                childNodes.add(new ObjectTreeNode(session, dbo));
            }
        }
        return childNodes;
    }

    protected List<ObjectTreeNode> createSchemaNodes(ISession session, SQLDatabaseMetaData md, String catalogName) throws SQLException {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        if (session.getProperties().getLoadSchemasCatalogs()) {
            session.getSchemaInfo().waitTillSchemasAndCatalogsLoaded();
            String[] schemas = session.getSchemaInfo().getSchemas();
            SchemaFilterMatcher filterMatcher = new SchemaFilterMatcher(session.getProperties());
            for (int i = 0; i < schemas.length; ++i) {
                DatabaseObjectInfo dbo = new DatabaseObjectInfo(catalogName, null, schemas[i], DatabaseObjectType.SCHEMA, md);
                if (!filterMatcher.matches(dbo.getSimpleName())) continue;
                childNodes.add(new ObjectTreeNode(session, dbo));
            }
        }
        return childNodes;
    }

    private List<ObjectTreeNode> createObjectTypeNodes(ISession session, String catalogName, String schemaName) {
        ArrayList<ObjectTreeNode> list = new ArrayList<ObjectTreeNode>();
        if (session.getProperties().getLoadSchemasCatalogs()) {
            ObjectTreeNode child;
            DatabaseObjectInfo dbo;
            ISQLConnection conn = session.getSQLConnection();
            SQLDatabaseMetaData md = conn.getSQLMetaData();
            TableTypeFilterMatcher ttMatcher = new TableTypeFilterMatcher(session.getProperties());
            if (this._tableTypes.length > 0) {
                for (int i = 0; i < this._tableTypes.length; ++i) {
                    dbo = new DatabaseObjectInfo(catalogName, schemaName, this._tableTypes[i], DatabaseObjectType.TABLE_TYPE_DBO, md);
                    if (!ttMatcher.matches(dbo.getSimpleName())) continue;
                    child = new ObjectTreeNode(session, dbo);
                    list.add(child);
                }
            } else {
                s_log.debug("List of table types is empty so trying null table type to load all tables");
                DatabaseObjectInfo dbo2 = new DatabaseObjectInfo(catalogName, schemaName, null, DatabaseObjectType.TABLE_TYPE_DBO, md);
                ObjectTreeNode child2 = new ObjectTreeNode(session, dbo2);
                child2.setUserObject("TABLE");
                list.add(child2);
            }
            boolean supportsStoredProcs = false;
            try {
                supportsStoredProcs = md.supportsStoredProcedures();
            }
            catch (SQLException ex) {
                s_log.debug("DBMS doesn't support 'supportsStoredProcedures()'", ex);
            }
            if (supportsStoredProcs) {
                dbo = new DatabaseObjectInfo(catalogName, schemaName, "PROCEDURE", DatabaseObjectType.PROC_TYPE_DBO, md);
                child = new ObjectTreeNode(session, dbo);
                list.add(child);
            }
            dbo = new DatabaseObjectInfo(catalogName, schemaName, "UDT", DatabaseObjectType.UDT_TYPE_DBO, md);
            child = new ObjectTreeNode(session, dbo);
            list.add(child);
        }
        return list;
    }
}

