/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableIndexExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.IndexParentInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class IndexParentExpander
implements INodeExpander {
    private static final ILogger s_log = LoggerController.createLogger(IndexParentExpander.class);
    private ITableIndexExtractor extractor = null;

    public void setTableIndexExtractor(ITableIndexExtractor extractor) {
        this.extractor = extractor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        IDatabaseObjectInfo tableInfo = ((IndexParentInfo)parentDbinfo).getTableInfo();
        ISQLConnection conn = session.getSQLConnection();
        SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = this.extractor.getTableIndexQuery();
            if (s_log.isDebugEnabled()) {
                s_log.debug("Running query for index extraction: " + query);
            }
            pstmt = conn.prepareStatement(query);
            this.extractor.bindParamters(pstmt, tableInfo);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String indexName = rs.getString(1);
                String cat = parentDbinfo.getCatalogName();
                String schema = parentDbinfo.getSchemaName();
                DatabaseObjectInfo doi = new DatabaseObjectInfo(cat, schema, indexName, DatabaseObjectType.INDEX, md);
                childNodes.add(new ObjectTreeNode(session, doi));
            }
            SQLUtilities.closeResultSet(rs, true);
        }
        catch (SQLException e) {
            session.showErrorMessage(e);
            s_log.error("Unexpected exception while extracting indexes for parent dbinfo: " + parentDbinfo, e);
        }
        finally {
            SQLUtilities.closeResultSet(rs, true);
        }
        return childNodes;
    }
}

