/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs;

import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class BaseObjectTab
implements IObjectTab {
    private static final ILogger s_log = LoggerController.createLogger(BaseObjectTab.class);
    protected IApplication _app;
    private IIdentifier _sessionId;
    private IDatabaseObjectInfo _dbObjInfo;
    private boolean _hasBeenDisplayed;

    @Override
    public void setSession(ISession session) throws IllegalArgumentException {
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        this._app = session.getApplication();
        this._sessionId = session.getIdentifier();
    }

    public final ISession getSession() {
        return this._app.getSessionManager().getSession(this._sessionId);
    }

    public DialectType getDialectType() {
        return DialectFactory.getDialectType(this.getSession().getMetaData());
    }

    @Override
    public synchronized void select() {
        if (!this._hasBeenDisplayed) {
            try {
                this.clear();
                this.refreshComponent();
            }
            catch (Throwable th) {
                s_log.error(th);
                this.getSession().showErrorMessage(th);
            }
            this._hasBeenDisplayed = true;
        }
    }

    @Override
    public void rebuild() {
        this._hasBeenDisplayed = false;
    }

    protected abstract void refreshComponent() throws DataSetException;

    @Override
    public void setDatabaseObjectInfo(IDatabaseObjectInfo value) {
        this._dbObjInfo = value;
        this._hasBeenDisplayed = false;
    }

    protected final IDatabaseObjectInfo getDatabaseObjectInfo() {
        return this._dbObjInfo;
    }
}

