/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs;

import java.awt.Component;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseObjectTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseSourcePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.LineNumber;
import net.sourceforge.squirrel_sql.fw.gui.textfind.TextFindCtrl;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class BaseSourceTab
extends BaseObjectTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(BaseSourceTab.class);
    private static final ILogger s_log = LoggerController.createLogger(BaseSourceTab.class);
    private final String _hint;
    private String _title;
    private BaseSourcePanel _comp;
    private JScrollPane _scroller;
    private TextFindCtrl _textFindCtrl;

    public BaseSourceTab(String hint) {
        this(null, hint);
    }

    public BaseSourceTab(String title, String hint) {
        this._title = title != null ? title : s_stringMgr.getString("BaseSourceTab.title");
        this._hint = hint != null ? hint : this._title;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    @Override
    public String getHint() {
        return this._hint;
    }

    @Override
    public void clear() {
    }

    @Override
    public Component getComponent() {
        if (this._scroller == null) {
            if (this._comp == null) {
                this._comp = this.createSourcePanel();
            }
            this._scroller = new JScrollPane(this._comp);
            LineNumber lineNumber = new LineNumber(this._comp);
            this._scroller.setRowHeaderView(lineNumber);
            this._scroller.getVerticalScrollBar().setUnitIncrement(10);
            this._textFindCtrl = new TextFindCtrl(this._comp.getTextArea(), this._scroller, true);
        }
        return this._textFindCtrl.getContainerPanel();
    }

    @Override
    protected void refreshComponent() {
        ISession session = this.getSession();
        if (session == null) {
            throw new IllegalStateException("Null ISession");
        }
        if (this._comp == null) {
            this._comp = this.createSourcePanel();
        }
        try {
            PreparedStatement pstmt = this.createStatement();
            try {
                this._comp.load(this.getSession(), pstmt);
            }
            finally {
                SQLUtilities.closeStatement(pstmt);
            }
        }
        catch (SQLException ex) {
            s_log.error(ex);
            session.showErrorMessage(ex);
        }
    }

    protected BaseSourcePanel createSourcePanel() {
        return new BaseSourcePanel(this.getSession()){

            @Override
            public void load(ISession session, PreparedStatement stmt) {
                BaseSourceTab.this.onLoad(this.getTextArea(), BaseSourceTab.this.getSourceCode(session, stmt));
            }
        };
    }

    protected PreparedStatement createStatement() throws SQLException {
        return null;
    }

    private void onLoad(JTextComponent textArea, String sourceCode) {
        textArea.setText(sourceCode);
        textArea.setCaretPosition(0);
    }

    protected String getSourceCode(ISession session, PreparedStatement stmt) {
        if (null == stmt) {
            String msg = "BaseSourceTab.createStatement() must be overridden to return non null when this base method is supposed to be used. You may as well simply override this method and return the source code any way you want";
            throw new IllegalStateException(msg);
        }
        StringBuilder buf = new StringBuilder(4096);
        try (ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                buf.append(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            session.showErrorMessage(ex);
        }
        return buf.toString();
    }
}

