/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseSourcePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseSourceTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.FormattedSourceTabCore;
import net.sourceforge.squirrel_sql.client.util.codereformat.CommentSpec;
import net.sourceforge.squirrel_sql.client.util.codereformat.ICodeReformator;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class FormattedSourceTab
extends BaseSourceTab {
    private static final ILogger s_log = LoggerController.createLogger(FormattedSourceTab.class);
    private FormattedSourceTabCore _core = new FormattedSourceTabCore();

    public FormattedSourceTab(String hint) {
        super(hint);
    }

    protected void setupFormatter(String stmtSep, CommentSpec[] commentSpecs) {
        this._core.setupFormatter(stmtSep, commentSpecs);
    }

    protected void setupFormatter(ICodeReformator codeReformator, String stmtSep, CommentSpec[] commentSpecs) {
        this._core.setupFormatter(codeReformator, stmtSep, commentSpecs);
    }

    protected void setCompressWhitespace(boolean compressWhitespace) {
        this._core.setCompressWhitespace(compressWhitespace);
    }

    @Override
    protected PreparedStatement createStatement() throws SQLException {
        ISession session = this.getSession();
        ISQLConnection conn = session.getSQLConnection();
        String sqlStatement = this.getSqlStatement();
        String[] bindValues = this.getBindValues();
        PreparedStatement pstmt = conn.prepareStatement(sqlStatement);
        int parameterIndex = 1;
        for (String bindValue : bindValues) {
            pstmt.setString(parameterIndex++, bindValue);
        }
        return pstmt;
    }

    protected abstract String getSqlStatement();

    protected String[] getBindValues() {
        IDatabaseObjectInfo doi = this.getDatabaseObjectInfo();
        return new String[]{doi.getSchemaName(), doi.getSimpleName()};
    }

    @Override
    protected BaseSourcePanel createSourcePanel() {
        return new BaseSourcePanel(this.getSession()){

            @Override
            public void load(ISession session, PreparedStatement stmt) {
                FormattedSourceTab.this._core.loadTextArea(this.getTextArea(), FormattedSourceTab.this.getSourceCode(session, stmt));
            }
        };
    }

    @Override
    protected String getSourceCode(ISession session, PreparedStatement stmt) {
        StringBuilder buf = new StringBuilder(4096);
        try (ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                String line = rs.getString(1);
                if (line == null) continue;
                if (this._core.isCompressWhitespace()) {
                    buf.append(line.trim() + " ");
                    continue;
                }
                buf.append(line);
            }
        }
        catch (Exception ex) {
            s_log.error("Unexpected exception while formatting object source code", ex);
            session.showErrorMessage(ex);
        }
        return buf.toString();
    }

    protected void setAppendSeparator(boolean b) {
        this._core.setAppendSeparator(b);
    }

    protected String getStatementSeparator() {
        return this._core.getStatementSeparator();
    }
}

