/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs;

import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformator;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformatorConfigFactory;
import net.sourceforge.squirrel_sql.client.util.codereformat.CommentSpec;
import net.sourceforge.squirrel_sql.client.util.codereformat.ICodeReformator;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class FormattedSourceTabCore {
    private static final ILogger s_log = LoggerController.createLogger(FormattedSourceTabCore.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FormattedSourceTabCore.class);
    private ICodeReformator _formatter = null;
    private boolean _compressWhitespace = true;
    private CommentSpec[] _commentSpecs = new CommentSpec[]{new CommentSpec("/*", "*/"), new CommentSpec("--", "\n")};
    private String _statementSeparator = null;
    private boolean appendSeparator = true;

    void setupFormatter(String stmtSep, CommentSpec[] commentSpecs) {
        this.setupFormatter(null, stmtSep, commentSpecs);
    }

    void setupFormatter(ICodeReformator codeReformator, String stmtSep, CommentSpec[] commentSpecs) {
        if (commentSpecs != null) {
            this._commentSpecs = commentSpecs;
        }
        this._statementSeparator = stmtSep;
        this._formatter = codeReformator;
        if (null == this._formatter) {
            this._formatter = new CodeReformator(CodeReformatorConfigFactory.createConfig(stmtSep, this._commentSpecs));
        }
    }

    void setCompressWhitespace(boolean compressWhitespace) {
        this._compressWhitespace = compressWhitespace;
    }

    boolean isCompressWhitespace() {
        return this._compressWhitespace;
    }

    String format(String toFormat) {
        String result = toFormat;
        try {
            result = this._formatter.reformat(toFormat);
        }
        catch (IllegalStateException e) {
            s_log.error("format: Formatting SQL failed: " + e.getMessage(), e);
        }
        return result;
    }

    void loadTextArea(JTextComponent textArea, String sourceCode) {
        textArea.setText("");
        if (this.appendSeparator && this._statementSeparator != null) {
            sourceCode = (String)sourceCode + "\n";
            sourceCode = (String)sourceCode + this._statementSeparator;
        }
        String processedResult = sourceCode;
        if (this._formatter != null && ((String)sourceCode).length() != 0) {
            textArea.setText(this.format(processedResult));
        } else {
            if (((String)sourceCode).length() == 0) {
                sourceCode = (String)sourceCode + s_stringMgr.getString("FormatterSourceTab.noSourceAvailable");
            }
            textArea.setText((String)sourceCode);
        }
        textArea.setCaretPosition(0);
    }

    boolean isAppendSeparator() {
        return this.appendSeparator;
    }

    void setAppendSeparator(boolean appendSeparator) {
        this.appendSeparator = appendSeparator;
    }

    public String getStatementSeparator() {
        return this._statementSeparator;
    }
}

