/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table;

import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.BaseTableTab;
import net.sourceforge.squirrel_sql.client.session.schemainfo.basetabletype.BaseTableTypeHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class IndexesTab
extends BaseTableTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(IndexesTab.class);
    private static final int[] indexIndices = new int[]{5, 6, 8, 9, 10, 4, 7, 11, 12, 13};

    @Override
    public String getTitle() {
        return s_stringMgr.getString("IndexesTab.title");
    }

    @Override
    public String getHint() {
        return s_stringMgr.getString("IndexesTab.hint");
    }

    @Override
    protected IDataSet createDataSet() throws DataSetException {
        ISQLConnection conn = this.getSession().getSQLConnection();
        SQLDatabaseMetaData dmd = conn.getSQLMetaData();
        ITableInfo ti = this.getTableInfo();
        if (!("TABLE".equalsIgnoreCase(ti.getType()) || "SYSTEM TABLE".equalsIgnoreCase(ti.getType()) || "GLOBAL TEMPORARY".equalsIgnoreCase(ti.getType()) || "LOCAL TEMPORARY".equalsIgnoreCase(ti.getType()) || BaseTableTypeHandler.isDatabaseUsingTypeBaseTableInsteadOpTable(dmd))) {
            return null;
        }
        ResultSetDataSet rsds = dmd.getIndexInfo(this.getTableInfo(), indexIndices, true);
        rsds.next(null);
        String indexName = (String)rsds.get(1);
        if (indexName == null) {
            rsds.removeRow(0);
        }
        rsds.resetCursor();
        return rsds;
    }
}

