/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.treefinder;

import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTree;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.treefinder.ObjectTreeFinderGoToNextResultHandle;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.treefinder.ObjectTreeSearchResultFuture;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.treefinder.ObjectTreeSearchResultFutureIntern;
import net.sourceforge.squirrel_sql.client.session.schemainfo.FilterMatcher;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ObjectTreeFinder {
    private static ILogger s_log = LoggerController.createLogger(ObjectTreeFinder.class);
    private final ObjectTree _objectTree;

    public ObjectTreeFinder(ObjectTree objectTree) {
        this._objectTree = objectTree;
    }

    public ObjectTreeSearchResultFuture findPathToDbInfo(String catalog, String schema, FilterMatcher objectMatcher, ObjectTreeNode startNode, boolean useExpanders, ObjectTreeFinderGoToNextResultHandle goToNextResultHandle) {
        ObjectTreeSearchResultFutureIntern toFill = new ObjectTreeSearchResultFutureIntern(this._objectTree.getSession());
        this._getPathToDbInfo(catalog, schema, objectMatcher, startNode, useExpanders, toFill, goToNextResultHandle);
        return toFill;
    }

    private void _getPathToDbInfo(String catalog, String schema, FilterMatcher objectMatcher, ObjectTreeNode startNode, boolean useExpanders, ObjectTreeSearchResultFutureIntern toFill, ObjectTreeFinderGoToNextResultHandle goToNextResultHandle) {
        if (this.dbObjectInfoEquals(catalog, schema, objectMatcher, startNode.getDatabaseObjectInfo()) && !goToNextResultHandle.isAPreviousResult(startNode.getPath())) {
            TreePath resultTreePath = new TreePath(startNode.getPath());
            goToNextResultHandle.addPreviousResult(resultTreePath);
            toFill.setTreePath(resultTreePath);
        } else {
            if (useExpanders && startNode.getAllowsChildren() && 0 == startNode.getChildCount() && !startNode.hasNoChildrenFoundWithExpander()) {
                toFill.addTask(this.getExpandDescr(startNode), () -> this._objectTree.expandNode(startNode));
            }
            toFill.addTask(this.getRecurseDescription(startNode), () -> this.recurseChildren(catalog, schema, objectMatcher, startNode, useExpanders, toFill, goToNextResultHandle));
            toFill.triggerExecution();
        }
    }

    private String getRecurseDescription(ObjectTreeNode startNode) {
        return "Checking " + new TreePath(startNode.getPath());
    }

    private String getExpandDescr(ObjectTreeNode startNode) {
        return "Loading child nodes of " + new TreePath(startNode.getPath());
    }

    private void recurseChildren(String catalog, String schema, FilterMatcher objectMatcher, ObjectTreeNode startNode, boolean useExpanders, ObjectTreeSearchResultFutureIntern toFill, ObjectTreeFinderGoToNextResultHandle goToNextResultHandle) {
        for (int i = 0; i < startNode.getChildCount(); ++i) {
            this._getPathToDbInfo(catalog, schema, objectMatcher, (ObjectTreeNode)startNode.getChildAt(i), useExpanders, toFill, goToNextResultHandle);
            if (null == toFill.getTreePath()) continue;
            return;
        }
    }

    private boolean dbObjectInfoEquals(String catalog, String schema, FilterMatcher objectMatcher, IDatabaseObjectInfo doi) {
        if (null != catalog && !catalog.equalsIgnoreCase(doi.getCatalogName())) {
            return false;
        }
        if (null != schema && !schema.equalsIgnoreCase(doi.getSchemaName())) {
            return false;
        }
        return null == objectMatcher.getMetaDataMatchString() || false != objectMatcher.matches(doi.getSimpleName()) || false != objectMatcher.getMetaDataMatchString().equalsIgnoreCase(doi.getQualifiedName());
    }
}

