/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.treefinder;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeFinderFinishListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.treefinder.ObjectTreeFinderTask;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.treefinder.ObjectTreeFinderTaskInfo;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.treefinder.ObjectTreeSearchResultFuture;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

class ObjectTreeSearchResultFutureIntern
implements ObjectTreeSearchResultFuture {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ObjectTreeSearchResultFutureIntern.class);
    public static final int MAX_PROGRESS = 50;
    private TreePath _treePath;
    private ISession _session;
    private final long _startTime;
    private ArrayList<ObjectTreeFinderTaskInfo> _taskList = new ArrayList();
    private boolean _isExecuting = false;
    private boolean _isFinished = false;
    private Timer _timer = new Timer(100, e -> this.onTimerTriggered());
    private int _taskIx = 0;
    private ArrayList<ObjectTreeFinderFinishListener> _listeners = new ArrayList();
    private int _progressValue;
    private ActionListener _stopActionListener = e -> this.onStop();

    ObjectTreeSearchResultFutureIntern(ISession session) {
        this._session = session;
        this._startTime = System.currentTimeMillis();
        this._session.addSimpleSessionListener(() -> this.disposeTimer());
    }

    void setTreePath(TreePath treePath) {
        this._treePath = treePath;
    }

    @Override
    public TreePath getTreePath() {
        return this._treePath;
    }

    @Override
    public void addFinishedListenerOrdered(ObjectTreeFinderFinishListener listener) {
        if (this._isFinished) {
            SwingUtilities.invokeLater(() -> listener.finderFinished(this._treePath));
            return;
        }
        this._listeners.remove(listener);
        this._listeners.add(listener);
    }

    @Override
    public void executeTillFinishNow() {
        this.disposeTimer();
        while (this.hasNextTask()) {
            this.nextTask().getTask().exec();
            if (null == this._treePath) continue;
        }
        if (!this._isFinished) {
            this.fireFinished();
        }
    }

    void addTask(String descr, ObjectTreeFinderTask task) {
        this._taskList.add(new ObjectTreeFinderTaskInfo(descr, task));
    }

    void triggerExecution() {
        if (this._isExecuting) {
            return;
        }
        this._isExecuting = true;
        while (this.hasNextTask()) {
            ObjectTreeFinderTaskInfo taskInfo = this.nextTask();
            taskInfo.getTask().exec();
            if (null != this._treePath) break;
            if (System.currentTimeMillis() - this._startTime <= 50L) continue;
            this._timer.start();
            this._progressValue = 4;
            this.increaseProgress(taskInfo.getDescr());
            return;
        }
        this.fireFinished();
    }

    private void increaseProgress(String taskDescr) {
        String msg = s_stringMgr.getString("ObjectTreeFinderResultFutureIntern.SearchingObjectTree", taskDescr);
        this._session.getSessionPanel().setStatusBarProgress(msg, 0, 50, ++this._progressValue % 50, this._stopActionListener);
    }

    private void onStop() {
        this.disposeTimer();
    }

    private void onTimerTriggered() {
        long thisTriggerEventsStartTime = System.currentTimeMillis();
        int counter = 0;
        while (this.hasNextTask()) {
            ObjectTreeFinderTaskInfo taskInfo = this.nextTask();
            taskInfo.getTask().exec();
            if (null != this._treePath) break;
            ++counter;
            if (System.currentTimeMillis() - thisTriggerEventsStartTime <= 50L) continue;
            this.increaseProgress(taskInfo.getDescr());
            return;
        }
        this.fireFinished();
    }

    private ObjectTreeFinderTaskInfo nextTask() {
        if (!this.hasNextTask()) {
            throw new IllegalStateException("No more tasks.");
        }
        return this._taskList.get(this._taskIx++);
    }

    private boolean hasNextTask() {
        return this._taskList.size() > this._taskIx;
    }

    private void fireFinished() {
        this.disposeTimer();
        for (ObjectTreeFinderFinishListener listener : this._listeners.toArray(new ObjectTreeFinderFinishListener[0])) {
            listener.finderFinished(this._treePath);
        }
        this._isFinished = true;
    }

    private void disposeTimer() {
        this._timer.stop();
        Arrays.stream(this._timer.getActionListeners()).forEach(al -> this._timer.removeActionListener((ActionListener)al));
        if (null != this._session.getSessionPanel()) {
            this._session.getSessionPanel().setStatusBarProgressFinished();
        }
    }
}

