/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.XYPair;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScale;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;

public class ScatterChartCreator {
    private final String _title;
    private final JFreeChart _chart;
    private final String _label;

    public ScatterChartCreator(DataScale xAxisDataScale, DataScale yAxisDataScale, DataScaleTable dataScaleTable) {
        this._title = "Scatter chart for x = " + xAxisDataScale.getColumnDisplayDefinition().getColumnName() + ", y = " + yAxisDataScale.getColumnDisplayDefinition().getColumnName();
        ArrayList<Double> xValues = dataScaleTable.getDoubleValuesForColumn(xAxisDataScale.getColumnDisplayDefinition());
        ArrayList<Double> yValues = dataScaleTable.getDoubleValuesForColumn(yAxisDataScale.getColumnDisplayDefinition());
        ArrayList<XYPair> pairs = XYPair.createSortedPairs(xValues, yValues);
        DefaultXYDataset defaultXYDataset = new DefaultXYDataset();
        double[][] series = new double[2][pairs.size()];
        for (int i = 0; i < pairs.size(); ++i) {
            series[0][i] = pairs.get(i).getX();
            series[1][i] = pairs.get(i).getY();
        }
        defaultXYDataset.addSeries((Comparable)((Object)this._title), series);
        this._chart = ChartFactory.createScatterPlot((String)this._title, (String)xAxisDataScale.getColumnDisplayDefinition().getColumnName(), (String)yAxisDataScale.getColumnDisplayDefinition().getColumnName(), (XYDataset)defaultXYDataset);
        StandardChartTheme.createJFreeTheme().apply(this._chart);
        this._label = "";
    }

    public String getTitle() {
        return this._title;
    }

    public JFreeChart getChart() {
        return this._chart;
    }

    public String getLabel() {
        return this._label;
    }
}

