/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleLayout;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScalePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.IndexedColumn;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.Interval;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.util.SquirrelConstants;

public class DataScale
implements Comparable<DataScale> {
    private DataScalePanel _panel;
    private ArrayList<Interval> _intervals = new ArrayList();
    private String _column;
    private DataScaleListener _dataScaleListener;
    private int _columnIndex;
    private ColumnDisplayDefinition _columnDisplayDefinition;
    private HashMap<JButton, Interval> _intervalByButton = new HashMap();
    private Color _defaultButtonBackgroundColor;

    public DataScale(String column, DataScaleListener dataScaleListener, int columnIndex, ColumnDisplayDefinition columnDisplayDefinition) {
        this._column = column;
        this._dataScaleListener = dataScaleListener;
        this._columnIndex = columnIndex;
        this._columnDisplayDefinition = columnDisplayDefinition;
    }

    public String getColumn() {
        return this._column;
    }

    public void addInterval(Interval interval) {
        this._intervals.add(interval);
    }

    public DataScalePanel getPanel() {
        if (null == this._panel) {
            int i;
            double[] wights = new double[this._intervals.size()];
            for (i = 0; i < this._intervals.size(); ++i) {
                wights[i] = this._intervals.get(i).getWight();
            }
            this._panel = new DataScalePanel(new DataScaleLayout(wights));
            for (i = 0; i < this._intervals.size(); ++i) {
                this._panel.add(this.createButton(i));
            }
        }
        return this._panel;
    }

    private JButton createButton(final int intervalIx) {
        String text = this._intervals.get(intervalIx).getLabel();
        final JButton ret = new JButton(text);
        this._defaultButtonBackgroundColor = ret.getBackground();
        ret.setToolTipText(this._intervals.get(intervalIx).getSmallToolTipHtml());
        ret.setBorder(BorderFactory.createLineBorder(Color.black));
        ret.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataScale.this.onButtonPressed(DataScale.this._intervals.get(intervalIx), ret);
            }
        });
        this._intervalByButton.put(ret, this._intervals.get(intervalIx));
        return ret;
    }

    private void onButtonPressed(Interval interval, JButton ret) {
        this._dataScaleListener.intervalSelected(interval, ret);
    }

    public double getSumWeights() {
        double ret = 0.0;
        for (Interval interval : this._intervals) {
            ret += interval.getWight();
        }
        return ret;
    }

    public int getSumLens() {
        int ret = 0;
        for (Interval interval : this._intervals) {
            ret += interval.getLen();
        }
        return ret;
    }

    @Override
    public int compareTo(DataScale other) {
        return Integer.valueOf(this._columnIndex).compareTo(other._columnIndex);
    }

    void showInTableSelected(JButton buttonPopupWasOpenedAt) {
        this._dataScaleListener.showInTable(this._intervalByButton.get(buttonPopupWasOpenedAt));
    }

    void showInTableWin(JButton buttonPopupWasOpenedAt) {
        this._dataScaleListener.showInTableWin(this._intervalByButton.get(buttonPopupWasOpenedAt));
    }

    public JButton[] getButtons() {
        return this._intervalByButton.keySet().toArray(new JButton[this._intervalByButton.keySet().size()]);
    }

    public ArrayList<String> getIntervalReports() {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < this._intervals.size(); ++i) {
            ret.add(this._intervals.get(i).getReport());
        }
        return ret;
    }

    public ArrayList<Interval> getIntervals() {
        return this._intervals;
    }

    public int getColumnIx() {
        return this._columnIndex;
    }

    public ColumnDisplayDefinition getColumnDisplayDefinition() {
        return this._columnDisplayDefinition;
    }

    public String getIntervalWidth() {
        if (0 == this._intervals.size()) {
            return null;
        }
        return this._intervals.get(this._intervals.size() - 1).getWidth();
    }

    public IndexedColumn getIndexedColumn() {
        return this._intervals.get(0).getIndexedColumn();
    }

    public void initButtonColor(JButton intervalButtonClicked) {
        for (JButton btn : this.getButtons()) {
            if (btn == intervalButtonClicked) {
                btn.setBackground(SquirrelConstants.FIND_COLOR);
                continue;
            }
            btn.setBackground(this._defaultButtonBackgroundColor);
        }
    }

    public void showIntervalDetails(JButton buttonPopupWasOpenedAt, Point dialogLocation) {
        Interval interval = this._intervalByButton.get(buttonPopupWasOpenedAt);
        this._dataScaleListener.showIntervalDetails(interval.getBigToolTipHtml(), dialogLocation);
    }
}

