/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTableCellEditor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTableColumnWidthsPersister;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTableModel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTablePopupHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.TableState;
import net.sourceforge.squirrel_sql.fw.gui.table.SortableTable;
import net.sourceforge.squirrel_sql.fw.gui.table.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DataScaleTable
extends SortableTable {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataScaleTable.class);
    private List<Object[]> _allRows;
    private ColumnDisplayDefinition[] _columnDefinitions;
    private DataScaleTable _parent;
    private DataScaleTable _kid;
    private DataSetViewerTablePanel _kidSimpleTable;

    public DataScaleTable(DataScaleTableModel dataScaleTableModel, List<Object[]> allRows, ColumnDisplayDefinition[] columnDefinitions) {
        super(dataScaleTableModel);
        this._allRows = allRows;
        this._columnDefinitions = columnDefinitions;
        this.setAutoResizeMode(0);
        this.setSelectionMode(0);
        new DataScaleTablePopupHandler(this);
        new DataScaleTableColumnWidthsPersister(this.getTableHeader());
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        String headerValue = (String)this.getColumnModel().getColumn(column).getHeaderValue();
        if (DataScaleTableModel.COL_NAME_COLUMN.equals(headerValue)) {
            TableCellRenderer cellRenderer = super.getCellRenderer(row, column);
            JLabel label = (JLabel)cellRenderer.getTableCellRendererComponent(this, headerValue, false, false, row, column);
            label.setToolTipText(s_stringMgr.getString("DataScaleTable.columnNameToolTip"));
            return cellRenderer;
        }
        DataScaleTableModel model = this.getDataScaleTableModel();
        return this.createScaleDataCellRenderer(model);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        String headerValue = (String)this.getColumnModel().getColumn(column).getHeaderValue();
        if (DataScaleTableModel.COL_NAME_COLUMN.equals(headerValue)) {
            return super.getCellEditor(row, column);
        }
        DataScaleTableModel model = this.getDataScaleTableModel();
        SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
        return new DataScaleTableCellEditor(model.getDataScaleAt(sortableTableModel.transformToModelRow(row)));
    }

    public DataScaleTableModel getDataScaleTableModel() {
        TableModel ret = ((SortableTableModel)this.getModel()).getActualModel();
        while (ret instanceof SortableTableModel) {
            ret = ((SortableTableModel)ret).getActualModel();
        }
        return (DataScaleTableModel)ret;
    }

    private TableCellRenderer createScaleDataCellRenderer(final DataScaleTableModel dataScaleTableModel) {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                SortableTableModel sortableTableModel = (SortableTableModel)DataScaleTable.this.getModel();
                return dataScaleTableModel.getDataScaleAt(sortableTableModel.transformToModelRow(row)).getPanel();
            }
        };
    }

    public List<Object[]> getAllRows() {
        return this._allRows;
    }

    public ColumnDisplayDefinition[] getColumnDisplayDefinitions() {
        return this._columnDefinitions;
    }

    public void setParentScaleTable(DataScaleTable parent) {
        TableState st = new TableState(parent);
        st.apply(this);
        this._parent = parent;
        this._parent.setKidScaleTable(this);
    }

    public void setKidScaleTable(DataScaleTable kid) {
        this._kid = kid;
        this._kidSimpleTable = null;
    }

    public DataScaleTable getKidScaleTable() {
        return this._kid;
    }

    public DataScaleTable getParentScaleTable() {
        return this._parent;
    }

    public void setKidSimpleTable(DataSetViewerTablePanel simpleTable) {
        this._kidSimpleTable = simpleTable;
        this._kid = null;
    }

    public DataSetViewerTablePanel getKidSimpleTable() {
        return this._kidSimpleTable;
    }

    public ArrayList<Double> getDoubleValuesForColumn(ColumnDisplayDefinition columnDisplayDefinition) {
        for (int i = 0; i < this._columnDefinitions.length; ++i) {
            if (this._columnDefinitions[i] != columnDisplayDefinition) continue;
            ArrayList<Double> ret = new ArrayList<Double>();
            for (Object[] row : this._allRows) {
                double value = 0.0;
                if (null != row[i]) {
                    value = row[i] instanceof Date ? (double)((Date)row[i]).getTime() : ((Number)row[i]).doubleValue();
                }
                ret.add(value);
            }
            return ret;
        }
        throw new IllegalArgumentException("Column not found " + columnDisplayDefinition.getColumnName());
    }
}

