/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScale;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTable;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTableModel;
import net.sourceforge.squirrel_sql.fw.gui.table.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DataScaleTablePopupHandler {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataScaleTablePopupHandler.class);
    private DataScaleTable _dataScaleTable;
    private JButton _buttonPopupWasOpenedAt;
    private DataScale _dataScalePopupWasOpenedAt;
    private MouseEvent _mouseEventOfPopup;

    DataScaleTablePopupHandler(DataScaleTable dataScaleTable) {
        this._dataScaleTable = dataScaleTable;
        this.attachListenersToTable(dataScaleTable);
        this.attachListenersToButtons(dataScaleTable);
    }

    private void attachListenersToButtons(DataScaleTable dataScaleTable) {
        final JPopupMenu popup = this.createPopupMenu();
        for (int i = 0; i < dataScaleTable.getDataScaleTableModel().getRowCount(); ++i) {
            JButton[] buttons;
            final DataScale dataScale = dataScaleTable.getDataScaleTableModel().getDataScaleAt(i);
            dataScale.getPanel();
            for (final JButton button : buttons = dataScale.getButtons()) {
                button.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent evt) {
                        DataScaleTablePopupHandler.this.maybeShowPopUpOnButton(evt, dataScale, button, popup);
                    }

                    @Override
                    public void mouseReleased(MouseEvent evt) {
                        DataScaleTablePopupHandler.this.maybeShowPopUpOnButton(evt, dataScale, button, popup);
                    }
                });
            }
        }
    }

    private void maybeShowPopUpOnButton(MouseEvent evt, DataScale dataScale, JButton button, JPopupMenu popup) {
        if (evt.isPopupTrigger()) {
            this._dataScalePopupWasOpenedAt = dataScale;
            this._buttonPopupWasOpenedAt = button;
            popup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void attachListenersToTable(DataScaleTable dataScaleTable) {
        final JPopupMenu popup = this.createPopupMenu();
        dataScaleTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DataScaleTablePopupHandler.this.maybeShowPopUpOnTable(evt, popup);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DataScaleTablePopupHandler.this.maybeShowPopUpOnTable(evt, popup);
            }
        });
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem mnuInTable = new JMenuItem(s_stringMgr.getString("DataScaleTablePopupHandler.showInTable"));
        mnuInTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataScaleTablePopupHandler.this._dataScalePopupWasOpenedAt.showInTableSelected(DataScaleTablePopupHandler.this._buttonPopupWasOpenedAt);
            }
        });
        popup.add(mnuInTable);
        JMenuItem mnuInTableWin = new JMenuItem(s_stringMgr.getString("DataScaleTablePopupHandler.showTableInWin"));
        mnuInTableWin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataScaleTablePopupHandler.this._dataScalePopupWasOpenedAt.showInTableWin(DataScaleTablePopupHandler.this._buttonPopupWasOpenedAt);
            }
        });
        popup.add(mnuInTableWin);
        JMenuItem mnuIntervalDetails = new JMenuItem(s_stringMgr.getString("DataScaleTablePopupHandler.ShowIntervalDetails"));
        mnuIntervalDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataScaleTablePopupHandler.this._dataScalePopupWasOpenedAt.showIntervalDetails(DataScaleTablePopupHandler.this._buttonPopupWasOpenedAt, DataScaleTablePopupHandler.this._mouseEventOfPopup.getLocationOnScreen());
            }
        });
        popup.add(mnuIntervalDetails);
        return popup;
    }

    private void maybeShowPopUpOnTable(MouseEvent evt, JPopupMenu popup) {
        if (evt.isPopupTrigger()) {
            this._mouseEventOfPopup = evt;
            Point point = new Point(evt.getX(), evt.getY());
            int colIx = this._dataScaleTable.columnAtPoint(point);
            String headerValue = (String)this._dataScaleTable.getColumnModel().getColumn(colIx).getHeaderValue();
            if (DataScaleTableModel.COL_NAME_DATA.equals(headerValue)) {
                int rowIx = this._dataScaleTable.rowAtPoint(point);
                DataScaleTableModel model = this._dataScaleTable.getDataScaleTableModel();
                SortableTableModel sortableTableModel = (SortableTableModel)this._dataScaleTable.getModel();
                int transformedRow = sortableTableModel.transformToModelRow(rowIx);
                this._dataScalePopupWasOpenedAt = model.getDataScaleAt(transformedRow);
                Rectangle rect = this._dataScaleTable.getCellRect(rowIx, colIx, false);
                int xInScalePanel = point.x - rect.x;
                int yInScalePanel = point.y - rect.y;
                this._buttonPopupWasOpenedAt = this._dataScalePopupWasOpenedAt.getPanel().getButtonAt(xInScalePanel);
                if (null != this._dataScalePopupWasOpenedAt && null != this._buttonPopupWasOpenedAt) {
                    popup.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        }
    }
}

