/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.rotatedtable;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Formatter;
import net.sourceforge.squirrel_sql.client.session.DataModelImplementationDetails;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.lazyresulttab.LazyTabControllerCtrl;
import net.sourceforge.squirrel_sql.client.session.mainpanel.rotatedtable.RotatedTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.SimpleDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.ResultTableType;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.DataSetViewerFindHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class RotatedTableCtrl
implements LazyTabControllerCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RotatedTableCtrl.class);
    private ISession _session;
    private RotatedTablePanel _rotatedTablePanel = new RotatedTablePanel();
    private DataSetViewerFindHandler _dataSetViewerFindHandler;

    public RotatedTableCtrl(ISession session) {
        this._session = session;
    }

    public static boolean isRotatedTablePanel(Component comp) {
        return comp instanceof RotatedTablePanel;
    }

    @Override
    public String getTitle() {
        return s_stringMgr.getString("rotatedTable.tab.name");
    }

    @Override
    public RotatedTablePanel getPanel() {
        return this._rotatedTablePanel;
    }

    @Override
    public void init(ResultSetDataSet rsds) {
        try {
            int rowCount = rsds.getAllDataForReadOnly().size();
            ColumnDisplayDefinition[] rotatedColDefs = new ColumnDisplayDefinition[rowCount + 1];
            rotatedColDefs[0] = new ColumnDisplayDefinition(20, s_stringMgr.getString("rotatedTable.ColName"));
            for (int i = 0; i < rowCount; ++i) {
                rotatedColDefs[i + 1] = new ColumnDisplayDefinition(20, s_stringMgr.getString("rotatedTable.rotatedCol", i + 1));
            }
            ArrayList<Object[]> rotatedRows = new ArrayList<Object[]>();
            for (int i = 0; i < rsds.getDataSetDefinition().getColumnDefinitions().length; ++i) {
                ColumnDisplayDefinition columnDisplayDefinition = rsds.getDataSetDefinition().getColumnDefinitions()[i];
                Object[] rotatedRow = new Object[rowCount + 1];
                rotatedRow[0] = columnDisplayDefinition.getColumnName();
                for (int j = 0; j < rowCount; ++j) {
                    Object[] row = rsds.getAllDataForReadOnly().get(j);
                    if (row[i] instanceof Byte[] || row[i] instanceof byte[]) {
                        Byte[] cellObjBytes;
                        if (row[i] instanceof Byte[]) {
                            cellObjBytes = (Byte[])row[i];
                        } else {
                            byte[] cellObjBytesPrimitives = (byte[])row[i];
                            cellObjBytes = new Byte[cellObjBytesPrimitives.length];
                            int k = 0;
                            for (byte b : cellObjBytesPrimitives) {
                                cellObjBytes[k++] = b;
                            }
                        }
                        Formatter formatter = new Formatter();
                        String format = "%02x";
                        Byte[] byteArray = cellObjBytes;
                        int n = byteArray.length;
                        for (int k = 0; k < n; ++k) {
                            byte b;
                            b = byteArray[k];
                            formatter.format(format, b);
                            format = "  %02x";
                        }
                        String objectArray = formatter.toString();
                        formatter.close();
                        rotatedRow[j + 1] = objectArray;
                        continue;
                    }
                    rotatedRow[j + 1] = row[i];
                }
                rotatedRows.add(rotatedRow);
            }
            SimpleDataSet simpleDataSet = new SimpleDataSet(rotatedRows, rotatedColDefs);
            DataSetViewerTablePanel table = new DataSetViewerTablePanel();
            table.init(null, new DataModelImplementationDetails(this._session), this._session);
            table.show(simpleDataSet);
            this._dataSetViewerFindHandler = new DataSetViewerFindHandler(table, this._session, ResultTableType.ROTATED_SQL_RESULT_TABLE);
            this._rotatedTablePanel.add(this._dataSetViewerFindHandler.getComponent());
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
    }

    public DataSetViewerFindHandler getDataSetViewerFindHandler() {
        return this._dataSetViewerFindHandler;
    }
}

