/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum.SumAndColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;

public class Calculator {
    static ArrayList<SumAndColumn> calculateSums(DataSetViewerTable table) {
        int[] selectedColumns = table.getSelectedColumns();
        int[] selectedRows = table.getSelectedRows();
        ArrayList<SumAndColumn> sums = new ArrayList<SumAndColumn>();
        for (int selectedColumn : selectedColumns) {
            SumAndColumn sumAndCol = Calculator.createSumAndColumn(table, selectedRows, selectedColumn);
            if (null == sumAndCol) continue;
            sums.add(sumAndCol);
        }
        return sums;
    }

    public static SumAndColumn calculateFirstSum(DataSetViewerTable table) {
        int selectedColumn = table.getSelectedColumn();
        if (-1 == selectedColumn) {
            return null;
        }
        int[] selectedRows = table.getSelectedRows();
        return Calculator.createSumAndColumn(table, selectedRows, selectedColumn);
    }

    private static SumAndColumn createSumAndColumn(DataSetViewerTable table, int[] selectedRows, int selectedColumn) {
        if (!(table.getColumnModel().getColumn(selectedColumn) instanceof ExtTableColumn)) {
            return null;
        }
        ExtTableColumn column = (ExtTableColumn)table.getColumnModel().getColumn(selectedColumn);
        ColumnDisplayDefinition columnDisplayDefinition = column.getColumnDisplayDefinition();
        SumAndColumn sumAndCol = null;
        if (Calculator.isIntegral(columnDisplayDefinition)) {
            long sum = 0L;
            for (int selectedRow : selectedRows) {
                Object raw = table.getValueAt(selectedRow, selectedColumn);
                if (!(raw instanceof Number)) continue;
                sum += ((Number)raw).longValue();
            }
            sumAndCol = new SumAndColumn(columnDisplayDefinition, sum);
        } else if (Calculator.isReal(columnDisplayDefinition)) {
            double sum = 0.0;
            for (int selectedRow : selectedRows) {
                Number number = (Number)table.getValueAt(selectedRow, selectedColumn);
                if (null == number) continue;
                sum += number.doubleValue();
            }
            sumAndCol = new SumAndColumn(columnDisplayDefinition, sum);
        }
        return sumAndCol;
    }

    private static boolean isIntegral(ColumnDisplayDefinition columnDisplayDefinition) {
        switch (columnDisplayDefinition.getSqlType()) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private static boolean isReal(ColumnDisplayDefinition columnDisplayDefinition) {
        switch (columnDisplayDefinition.getSqlType()) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }
}

