/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum;

import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum.Calculator;
import net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum.FunctionDialog;
import net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum.SumAndColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.SimpleDataSet;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class FunctionController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FunctionController.class);
    private FunctionDialog _dlg;
    private final DataSetViewerTablePanel _functionValuesTablePanel;

    public FunctionController(JPanel parent) {
        this._dlg = new FunctionDialog(GUIUtils.getOwningFrame(parent), s_stringMgr.getString("FunctionController.title"));
        this._dlg.setDefaultCloseOperation(2);
        this._dlg.getContentPane().setLayout(new GridLayout(1, 1));
        this._functionValuesTablePanel = new DataSetViewerTablePanel();
        this._functionValuesTablePanel.init(null, null);
        this._dlg.getContentPane().add(new JScrollPane(this._functionValuesTablePanel.getComponent()));
        GUIUtils.enableCloseByEscape(this._dlg);
        GUIUtils.initLocation(this._dlg, 250, 150);
        this._dlg.setVisible(true);
    }

    public boolean isDisposed() {
        if (!this._dlg.isVisible()) {
            this._dlg.dispose();
            return true;
        }
        return false;
    }

    public ArrayList<SumAndColumn> update(DataSetViewerTable table) {
        try {
            ArrayList<SumAndColumn> sums = Calculator.calculateSums(table);
            ArrayList<ColumnDisplayDefinition> columns = new ArrayList<ColumnDisplayDefinition>();
            columns.add(new ColumnDisplayDefinition(10, s_stringMgr.getString("FunctionController.function")));
            columns.addAll(sums.stream().map(s -> s.getColumnDisplayDefinition()).collect(Collectors.toList()));
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            Object[] sumRow = new Object[sums.size() + 1];
            sumRow[0] = s_stringMgr.getString("FunctionController.sums");
            for (int i = 0; i < sums.size(); ++i) {
                sumRow[i + 1] = sums.get(i).getSum();
            }
            rows.add(sumRow);
            SimpleDataSet simpleDataSet = new SimpleDataSet(rows, columns.toArray(new ColumnDisplayDefinition[0]));
            this._functionValuesTablePanel.show(simpleDataSet);
            return sums;
        }
        catch (DataSetException e) {
            throw Utilities.wrapRuntime(e);
        }
    }
}

