/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum.RowColAndSumDisplay;
import net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum.RowColLabelController;
import net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum.RowColSumLayoutListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum.SumFunctionController;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewer;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.buttonchooser.ComboButton;
import net.sourceforge.squirrel_sql.fw.props.Props;

public class RowColAndSumController {
    private static final String PREF_KEY_ROW_COL_AND_SUM_DISPLAY = "RowColAndSumController.RowColAndSumDisplay";
    private final JPanel _panel;
    private final JPanel _containerPanel = new JPanel();
    private RowColLabelController _selectRowColLabelController = new RowColLabelController();
    private SumFunctionController _sumFunctionController = new SumFunctionController();
    private IDataSetViewer _dataSetViewer;
    private RowColAndSumDisplay _rowColAndSumDisplay;
    private RowColSumLayoutListener _rowColSumLayoutListener;

    public RowColAndSumController() {
        this._panel = new JPanel(new BorderLayout(0, 0));
        ComboButton btnCombo = new ComboButton();
        GUIUtils.styleAsToolbarButton(btnCombo);
        this.onDisplaySelected(RowColAndSumDisplay.valueOf(Props.getString(PREF_KEY_ROW_COL_AND_SUM_DISPLAY, RowColAndSumDisplay.ROW_COLS.name())));
        btnCombo.addActionListener(e -> this.onComboSelectDisplay(btnCombo));
        this._panel.add((Component)btnCombo, "West");
        this._panel.add((Component)this._containerPanel, "Center");
    }

    public void setRowColSumLayoutListener(RowColSumLayoutListener rowColSumLayoutListener) {
        this._rowColSumLayoutListener = rowColSumLayoutListener;
        this._sumFunctionController.setRowColSumLayoutListener(rowColSumLayoutListener);
    }

    private void onComboSelectDisplay(ComboButton comboButton) {
        JPopupMenu popupMenu = new JPopupMenu();
        for (RowColAndSumDisplay value : RowColAndSumDisplay.values()) {
            JMenuItem menuItem = new JMenuItem(value.toString());
            menuItem.addActionListener(e -> this.onDisplaySelected(value));
            popupMenu.add(menuItem);
        }
        popupMenu.addPopupMenuListener(comboButton.getPopupMenuListener());
        popupMenu.show(comboButton, 0, comboButton.getHeight());
    }

    private void onDisplaySelected(RowColAndSumDisplay rowColAndSumDisplay) {
        this._rowColAndSumDisplay = rowColAndSumDisplay;
        Props.putString(PREF_KEY_ROW_COL_AND_SUM_DISPLAY, rowColAndSumDisplay.name());
        this._containerPanel.removeAll();
        switch (rowColAndSumDisplay) {
            case ROW_COLS: {
                this._containerPanel.setLayout(new GridLayout(1, 1));
                this._containerPanel.add(this._selectRowColLabelController.getPanel());
                break;
            }
            case SUM_FUNCTIONS: {
                this._containerPanel.setLayout(new GridLayout(1, 1));
                this._containerPanel.add(this._sumFunctionController.getPanel());
                break;
            }
            case BOTH: {
                this._containerPanel.setLayout(new BorderLayout(3, 3));
                this._containerPanel.add((Component)this._selectRowColLabelController.getPanel(), "West");
                JPanel separator = GUIUtils.createVerticalSeparatorPanel();
                this._containerPanel.add(separator);
                this._containerPanel.add((Component)this._sumFunctionController.getPanel(), "East");
            }
        }
        this.callSelectionChanged();
        if (null != this._rowColSumLayoutListener) {
            this._rowColSumLayoutListener.rowColSumLayoutDone();
        }
    }

    private void callSelectionChanged() {
        if (this._dataSetViewer instanceof DataSetViewerTablePanel) {
            DataSetViewerTable table = ((DataSetViewerTablePanel)this._dataSetViewer).getTable();
            this.onRowColSelectedCountOrPosChanged(table.getSelectedRowCount(), table.getSelectedColumnCount(), table.getSelectedRow(), table.getSelectedColumn());
        } else {
            this.onRowColSelectedCountOrPosChanged(0, 0, -1, -1);
        }
    }

    public JPanel getPanel() {
        return this._panel;
    }

    public void setDataSetViewer(IDataSetViewer dataSetViewer) {
        this._dataSetViewer = dataSetViewer;
        this._dataSetViewer.addRowColSelectedCountListener((selRowCount, selColCount, selRow, selColumn) -> this.onRowColSelectedCountOrPosChanged(selRowCount, selColCount, selRow, selColumn));
        this.callSelectionChanged();
    }

    private void onRowColSelectedCountOrPosChanged(int selectedRowCount, int selectedColumnCount, int selectedRow, int selectedColumn) {
        if (this._rowColAndSumDisplay == RowColAndSumDisplay.ROW_COLS || this._rowColAndSumDisplay == RowColAndSumDisplay.BOTH) {
            if (null != this._dataSetViewer && 0 == this._dataSetViewer.getRowCount()) {
                this._selectRowColLabelController.onRowColSelectionChanged(0, 0, -1, -1);
            } else {
                this._selectRowColLabelController.onRowColSelectionChanged(selectedRowCount, selectedColumnCount, selectedRow, selectedColumn);
            }
        }
        if ((this._rowColAndSumDisplay == RowColAndSumDisplay.SUM_FUNCTIONS || this._rowColAndSumDisplay == RowColAndSumDisplay.BOTH) && this._dataSetViewer instanceof DataSetViewerTablePanel) {
            this._sumFunctionController.onSelectionChanged(((DataSetViewerTablePanel)this._dataSetViewer).getTable());
        }
    }
}

