/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.gui.ClipboardUtil;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class RowColLabelController
extends Component {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RowColLabelController.class);
    private JTextField _txtSelection = GUIUtils.styleTextFieldToCopyableLabel(new JTextField());
    private JTextField _txtPosition = GUIUtils.styleTextFieldToCopyableLabel(new JTextField());
    private JPanel _panel = new JPanel(new GridLayout(2, 1));
    private int _selectedRowCount;
    private int _selectedColumnCount;
    private int _selectedRow;
    private int _selectedColumn;

    public RowColLabelController() {
        this._panel.add(this._txtSelection);
        this._panel.add(this._txtPosition);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RowColLabelController.this.onMousePressedTxtFields(RowColLabelController.this._txtSelection, e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                RowColLabelController.this.onMousePressedTxtFields(RowColLabelController.this._txtSelection, e);
            }
        };
        this._txtSelection.addMouseListener(mouseAdapter);
        this._txtPosition.addMouseListener(mouseAdapter);
    }

    private void onMousePressedTxtFields(JTextField txtField, MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(s_stringMgr.getString("RowColLabelController.copy.all"));
        menuItem.addActionListener(ae -> this.onCopyAll());
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(s_stringMgr.getString("RowColLabelController.copy.selected.rows"));
        menuItem.addActionListener(ae -> this.onCopySelectedRowCount());
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(s_stringMgr.getString("RowColLabelController.copy.selected.cols"));
        menuItem.addActionListener(ae -> this.onCopySelectedCols());
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(s_stringMgr.getString("RowColLabelController.copy.pos.row"));
        menuItem.addActionListener(ae -> this.onCopyPosRow());
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(s_stringMgr.getString("RowColLabelController.copy.pos.col"));
        menuItem.addActionListener(ae -> this.onCopyPosCol());
        popupMenu.add(menuItem);
        popupMenu.show(txtField, e.getX(), e.getY());
    }

    private void onCopyAll() {
        ClipboardUtil.copyToClip(RowColLabelController.getSelectionDisplayString(this._selectedRowCount, this._selectedColumnCount) + "\n" + RowColLabelController.getPosDisplayString(this._selectedRow, this._selectedColumn));
    }

    private void onCopyPosCol() {
        ClipboardUtil.copyToClip("" + (this._selectedColumn + 1));
    }

    private void onCopyPosRow() {
        ClipboardUtil.copyToClip("" + (this._selectedRow + 1));
    }

    private void onCopySelectedCols() {
        ClipboardUtil.copyToClip("" + this._selectedColumnCount);
    }

    private void onCopySelectedRowCount() {
        ClipboardUtil.copyToClip("" + this._selectedRowCount);
    }

    public JPanel getPanel() {
        return this._panel;
    }

    void onRowColSelectionChanged(int selectedRowCount, int selectedColumnCount, int selectedRow, int selectedColumn) {
        this._selectedRowCount = selectedRowCount;
        this._selectedColumnCount = selectedColumnCount;
        this._selectedRow = selectedRow;
        this._selectedColumn = selectedColumn;
        this._txtSelection.setText(RowColLabelController.getSelectionDisplayString(selectedRowCount, selectedColumnCount));
        this._txtPosition.setText(RowColLabelController.getPosDisplayString(selectedRow, selectedColumn));
    }

    private static String getPosDisplayString(int selectedRow, int selectedColumn) {
        return s_stringMgr.getString("SelectRowColLabelController.RowColPositionLabel", selectedRow == -1 ? "" : Integer.valueOf(selectedRow + 1), selectedColumn == -1 ? "" : Integer.valueOf(selectedColumn + 1));
    }

    private static String getSelectionDisplayString(int selectedRowCount, int selectedColumnCount) {
        return s_stringMgr.getString("SelectRowColLabelController.RowColSelectedCountLabel", selectedRowCount, selectedColumnCount);
    }
}

